/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.SharedUtil;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolInternal;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.ToolsExtensionImpl;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.shadow.net.minecraftforge.util.hash.HashStore;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.jetbrains.annotations.Nullable;

class ToolImpl
implements ToolInternal {
    private static final long serialVersionUID = -862411638019629688L;
    private static final Logger LOGGER = Logging.getLogger(Tool.class);
    private final String name;
    private final String version;
    private final String fileName;
    private final String downloadUrl;
    private final int javaVersion;
    @Nullable
    private final String mainClass;

    public ToolImpl(String name, String version, String fileName, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this.name = name;
        this.version = version;
        this.fileName = fileName;
        this.downloadUrl = downloadUrl;
        this.javaVersion = javaVersion;
        this.mainClass = mainClass;
    }

    ToolImpl(String name, String version, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this(name, version, String.format("%s-%s.jar", name, version), downloadUrl, javaVersion, mainClass);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public int getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    @Nullable
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public Tool.Resolved get(Provider<? extends Directory> cachesDir, ToolsExtensionImpl toolsExt) {
        Tool.Definition definition = (Tool.Definition)toolsExt.definitions.maybeCreate(this.name);
        ConfigurableFileCollection classpath = definition.getClasspath();
        if (classpath.isEmpty()) {
            classpath = toolsExt.getObjects().fileCollection().from(new Object[]{toolsExt.getProviders().of(Source.class, spec -> spec.parameters(parameters -> {
                parameters.getInputFile().set(cachesDir.map(d -> d.file("tools/" + this.fileName)));
                parameters.getDownloadUrl().set((Object)this.downloadUrl);
            }))});
        }
        return new ResolvedImpl(toolsExt.getObjects(), (FileCollection)classpath, definition.getMainClass().orElse(toolsExt.getProviders().provider(this::getMainClass)), definition.getJavaLauncher().orElse(SharedUtil.launcherForStrictly(toolsExt.getJavaToolchains(), this.getJavaVersion())));
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile(outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile(outFile, downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            public RegularFileProperty getInputFile();

            public Property<String> getDownloadUrl();
        }
    }

    private class ResolvedImpl
    implements Tool.Resolved {
        private final FileCollection classpath;
        private final Property<String> mainClass;
        private final Property<JavaLauncher> javaLauncher;

        private ResolvedImpl(ObjectFactory objects, FileCollection classpath, Provider<? extends String> mainClass, Provider<? extends JavaLauncher> javaLauncher) {
            this.classpath = classpath;
            this.mainClass = objects.property(String.class).value(mainClass);
            this.javaLauncher = objects.property(JavaLauncher.class).value(javaLauncher);
        }

        @Override
        public FileCollection getClasspath() {
            return this.classpath;
        }

        @Override
        public String getName() {
            return ToolImpl.this.getName();
        }

        @Override
        public String getVersion() {
            return ToolImpl.this.getVersion();
        }

        @Override
        public Property<JavaLauncher> getJavaLauncher() {
            return this.javaLauncher;
        }

        @Override
        public int getJavaVersion() {
            return ((JavaLauncher)this.javaLauncher.get()).getMetadata().getLanguageVersion().asInt();
        }

        @Override
        @Nullable
        public String getMainClass() {
            return (String)this.mainClass.getOrNull();
        }
    }
}

