/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import groovy.lang.GroovyObjectSupport;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.ProblemGroup;
import org.gradle.api.problems.ProblemId;
import org.gradle.api.problems.ProblemReporter;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.Severity;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.jetbrains.annotations.Nullable;

public abstract class EnhancedProblems
extends GroovyObjectSupport
implements Problems,
Predicate<String> {
    protected static final String HELP_MESSAGE = "Consult the documentation or ask for help on the Forge Forums, GitHub, or Discord server.";
    private final String displayName;
    private final ProblemGroup problemGroup;
    private final Problems delegate;
    private final Predicate<String> properties;

    public ProblemReporter getReporter() {
        return this.delegate.getReporter();
    }

    public final ProblemGroup getProblemGroup() {
        return this.problemGroup;
    }

    protected EnhancedProblems(String name, String displayName) {
        this.displayName = displayName;
        this.problemGroup = ProblemGroup.create((String)name, (String)this.displayName);
        this.delegate = this.unwrapProblems();
        this.properties = this.unwrapProperties();
    }

    protected final ProblemId id(String name, String displayName) {
        return ProblemId.create((String)name, (String)displayName, (ProblemGroup)this.getProblemGroup());
    }

    @Override
    public final boolean test(String property) {
        return this.properties.test(property);
    }

    public final RuntimeException illegalPluginTarget(Exception e, Class<?> firstAllowedTarget, Class<?> ... allowedTargets) {
        return this.getReporter().throwing((Throwable)e, this.id("invalid-plugin-target", "Invalid plugin target"), spec -> spec.details(String.format("Attempted to apply the %s plugin to an invalid target.\nThis plugin can only be applied on the following types:\n%s", this.displayName, Stream.concat(Stream.of(firstAllowedTarget), Stream.of(allowedTargets)).map(Class::getName).collect(Collectors.joining(", ", "[", "]")))).severity(Severity.ERROR).stackLocation().solution("Use a valid plugin target.").solution(HELP_MESSAGE));
    }

    public final RuntimeException illegalPluginTarget(Exception e, String allowedTargets) {
        return this.getReporter().throwing((Throwable)e, this.id("invalid-plugin-target", "Invalid plugin target"), spec -> spec.details(String.format("Attempted to apply the %s plugin to an invalid target.\nThis plugin can only be applied on %s", this.displayName, allowedTargets)).severity(Severity.ERROR).stackLocation().solution("Use a valid plugin target.").solution(HELP_MESSAGE));
    }

    public final RuntimeException pluginNotYetApplied(Exception e) {
        return this.getReporter().throwing((Throwable)e, this.id("plugin-not-yet-applied", String.format("%s is not applied", this.displayName)), spec -> spec.details(String.format("Attempted to get details from the %s plugin, but it has not yet been applied to the target.", this.displayName)).severity(Severity.ERROR).stackLocation().solution("Apply the plugin before attempting to use it from the target's plugin manager.").solution("Apply the plugin before attempting to register any of its tasks, especially those that require in-house caching or tools.").solution(HELP_MESSAGE));
    }

    public final void reportToolExecNotEnhanced(Task task) {
        this.getReporter().report(this.id("tool-exec-not-enhanced", "ToolExec subclass doesn't implement EnhancedTask"), spec -> spec.details(String.format("Implementing subclass of ToolExecBase should also implement (a subclass of) EnhancedTask.\nNot doing so will result in global caches being ignored. Please check your implementations.\nAffected task: %s (%s)", task, task.getClass())).severity(Severity.WARNING).stackLocation().solution("Double check your task implementation."));
    }

    public final void reportToolExecNotEnhanced(Class<?> task) {
        this.getReporter().report(this.id("enhanced-task-no-plugin", "EnhancedTask doesn't implement #pluginType"), spec -> spec.details(String.format("Implementation of EnhancedTask must implement #pluginType\nAffected task type: %s", task)).severity(Severity.ERROR).stackLocation().solution("Double check your task implementation."));
    }

    public final void reportToolExecEagerArgs(Task task) {
        this.getReporter().report(this.id("tool-exec-eager-args", "ToolExecBase implementation adds arguments without using addArguments()"), spec -> spec.details(String.format("A ToolExecBase task is eagerly adding arguments using JavaExec#args without using ToolExecBase#addArguments.\nThis may cause implementations or superclasses to have their arguments ignored or missing.\nAffected task: %s (%s)", task, task.getClass())).severity(Severity.WARNING).stackLocation().solution("Use ToolExecBase#addArguments"));
    }

    public final <T extends FileSystemLocation> Transformer<T, T> ensureFileLocation() {
        return file -> {
            File dir = file instanceof Directory ? file.getAsFile() : file.getAsFile().getParentFile();
            try {
                Files.createDirectories(dir.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw this.getReporter().throwing((Throwable)e, this.id("cannot-ensure-directory", "Failed to create directory"), spec -> spec.details(String.format("Failed to create a directory required for %s to function.\nDirectory: %s", this.displayName, dir.getAbsolutePath())).severity(Severity.ERROR).stackLocation().solution("Ensure that the you have write access to the directory that needs to be created.").solution(HELP_MESSAGE));
            }
            return file;
        };
    }

    @Inject
    protected Problems getProblems() {
        throw new IllegalStateException();
    }

    @Inject
    protected ProviderFactory getProviders() {
        throw new IllegalStateException();
    }

    private Problems unwrapProblems() {
        try {
            return this.getProblems();
        }
        catch (Exception e) {
            return EmptyReporter.AS_PROBLEMS;
        }
    }

    private Predicate<String> unwrapProperties() {
        try {
            ProviderFactory providers = Objects.requireNonNull(this.getProviders());
            return property -> EnhancedProblems.isTrue(providers, property);
        }
        catch (Exception e) {
            return Boolean::getBoolean;
        }
    }

    @Nullable
    private static Boolean getBoolean(Provider<? extends String> provider) {
        if (Boolean.TRUE.equals(provider.map("true"::equalsIgnoreCase).getOrNull())) {
            return true;
        }
        if (Boolean.FALSE.equals(provider.map("false"::equalsIgnoreCase).getOrNull())) {
            return false;
        }
        return null;
    }

    private static boolean isTrue(ProviderFactory providers, String property) {
        return EnhancedProblems.isTrue((Provider<? extends String>)providers.gradleProperty(property)) || EnhancedProblems.isTrue((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isTrue(Provider<? extends String> provider) {
        return Boolean.TRUE.equals(EnhancedProblems.getBoolean(provider));
    }

    private static boolean isFalse(ProviderFactory providers, String property) {
        return EnhancedProblems.isFalse((Provider<? extends String>)providers.gradleProperty(property)) || EnhancedProblems.isFalse((Provider<? extends String>)providers.systemProperty(property));
    }

    private static boolean isFalse(Provider<? extends String> provider) {
        return Boolean.FALSE.equals(EnhancedProblems.getBoolean(provider));
    }

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (Exception suppressed) {
            try {
                return InvokerHelper.getMetaClass((Object)this.delegate).invokeMethod((Object)this.delegate, name, args);
            }
            catch (Exception e) {
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    public Object getProperty(String propertyName) {
        try {
            return super.getProperty(propertyName);
        }
        catch (Exception suppressed) {
            try {
                return InvokerHelper.getProperty((Object)this.delegate, (String)propertyName);
            }
            catch (Exception e) {
                e.addSuppressed(suppressed);
                throw e;
            }
        }
    }

    static abstract class Minimal
    extends EnhancedProblems
    implements HasPublicType {
        @Inject
        public Minimal(String name, String displayName) {
            super(name, displayName);
        }

        public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(EnhancedProblems.class);
        }
    }

    private static interface EmptyReporter
    extends ProblemReporter,
    HasPublicType {
        public static final EmptyReporter INSTANCE = new EmptyReporter(){};
        public static final Problems AS_PROBLEMS = () -> INSTANCE;

        default public TypeOf<?> getPublicType() {
            return TypeOf.typeOf(ProblemReporter.class);
        }

        default public Problem create(ProblemId problemId, Action<? super ProblemSpec> action) {
            return new Problem(){};
        }

        default public void report(ProblemId problemId, Action<? super ProblemSpec> spec) {
        }

        default public void report(Problem problem) {
        }

        default public void report(Collection<? extends Problem> problems) {
        }

        default public RuntimeException throwing(Throwable exception, ProblemId problemId, Action<? super ProblemSpec> spec) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Problem problem) {
            return this.toRTE(exception);
        }

        default public RuntimeException throwing(Throwable exception, Collection<? extends Problem> problems) {
            return this.toRTE(exception);
        }

        default public RuntimeException toRTE(Throwable exception) {
            return exception instanceof RuntimeException ? (RuntimeException)exception : new RuntimeException(exception);
        }
    }
}

