/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FirstParam;
import java.io.File;
import java.io.OutputStream;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Closures;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;
import org.gradle.jvm.toolchain.JavaToolchainSpec;
import org.jetbrains.annotations.Contract;

public abstract class SharedUtil {
    public static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherFor(JavaPluginExtension java, JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        JavaToolchainSpec currentToolchain = java.getToolchain();
        return currentToolchain.getLanguageVersion().orElse((Object)JavaLanguageVersion.current()).flatMap(languageVersion -> languageVersion.canCompileOrRun(version) ? javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set(languageVersion)) : SharedUtil.launcherForStrictly(javaToolchains, version));
    }

    public static Provider<JavaLauncher> launcherFor(Provider<? extends JavaPluginExtension> java, Provider<? extends JavaToolchainService> javaToolchains, int version) {
        return SharedUtil.launcherFor(java, javaToolchains, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherFor(Provider<? extends JavaPluginExtension> java, Provider<? extends JavaToolchainService> javaToolchains, JavaLanguageVersion version) {
        return java.flatMap(j -> {
            JavaToolchainSpec currentToolchain = j.getToolchain();
            return currentToolchain.getLanguageVersion().orElse((Object)JavaLanguageVersion.current()).flatMap(languageVersion -> languageVersion.canCompileOrRun(version) ? javaToolchains.flatMap(t -> t.launcherFor(spec -> spec.getLanguageVersion().set(languageVersion))) : SharedUtil.launcherForStrictly(javaToolchains, version));
        });
    }

    public static Provider<JavaLauncher> launcherFor(Project project, int version) {
        ProviderFactory providers = project.getProviders();
        ExtensionContainer extensions = project.getExtensions();
        return SharedUtil.launcherFor((Provider<? extends JavaPluginExtension>)providers.provider(() -> (JavaPluginExtension)extensions.getByType(JavaPluginExtension.class)), (Provider<? extends JavaToolchainService>)providers.provider(() -> (JavaToolchainService)extensions.getByType(JavaToolchainService.class)), version);
    }

    public static Provider<JavaLauncher> launcherFor(Project project, JavaLanguageVersion version) {
        ProviderFactory providers = project.getProviders();
        ExtensionContainer extensions = project.getExtensions();
        return SharedUtil.launcherFor((Provider<? extends JavaPluginExtension>)providers.provider(() -> (JavaPluginExtension)extensions.getByType(JavaPluginExtension.class)), (Provider<? extends JavaToolchainService>)providers.provider(() -> (JavaToolchainService)extensions.getByType(JavaToolchainService.class)), version);
    }

    public static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, int version) {
        return SharedUtil.launcherForStrictly(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherForStrictly(JavaToolchainService javaToolchains, JavaLanguageVersion version) {
        return javaToolchains.launcherFor(spec -> spec.getLanguageVersion().set((Object)version));
    }

    public static Provider<JavaLauncher> launcherForStrictly(Provider<? extends JavaToolchainService> javaToolchains, int version) {
        return SharedUtil.launcherForStrictly(javaToolchains, JavaLanguageVersion.of((int)version));
    }

    public static Provider<JavaLauncher> launcherForStrictly(Provider<? extends JavaToolchainService> javaToolchains, JavaLanguageVersion version) {
        return javaToolchains.flatMap(t -> t.launcherFor(spec -> spec.getLanguageVersion().set((Object)version)));
    }

    public static Provider<JavaLauncher> launcherForStrictly(Project project, int version) {
        ProviderFactory providers = project.getProviders();
        ExtensionContainer extensions = project.getExtensions();
        return SharedUtil.launcherForStrictly((Provider<? extends JavaToolchainService>)providers.provider(() -> (JavaToolchainService)extensions.getByType(JavaToolchainService.class)), version);
    }

    public static Provider<JavaLauncher> launcherForStrictly(Project project, JavaLanguageVersion version) {
        ProviderFactory providers = project.getProviders();
        ExtensionContainer extensions = project.getExtensions();
        return SharedUtil.launcherForStrictly((Provider<? extends JavaToolchainService>)providers.provider(() -> (JavaToolchainService)extensions.getByType(JavaToolchainService.class)), version);
    }

    public static void ensureAfterEvaluate(Project project, @DelegatesTo(value=Project.class, strategy=1) @ClosureParams(value=FirstParam.class) Closure<?> closure) {
        SharedUtil.ensureAfterEvaluate(project, Closures.toAction(closure));
    }

    public static void ensureAfterEvaluate(Project project, Action<? super Project> action) {
        if (project.getState().getExecuted()) {
            action.execute((Object)project);
        } else {
            project.afterEvaluate(action);
        }
    }

    public static OutputStream toLog(final Action<? super String> logger) {
        return new OutputStream(){
            private StringBuffer buffer = new StringBuffer(512);

            @Override
            public void write(int b) {
                if (b == 13 || b == 10) {
                    if (this.buffer.length() > 0) {
                        logger.execute((Object)this.buffer.toString());
                        this.buffer = new StringBuffer(512);
                    }
                } else {
                    this.buffer.append(b);
                }
            }
        };
    }

    public static String toString(ModuleVersionSelector module) {
        String version = module.getVersion();
        return String.format("%s:%s%s", module.getGroup(), module.getName(), version != null ? ':' + version : "");
    }

    public static String toString(Dependency dependency) {
        String string;
        String group = dependency.getGroup();
        String version = dependency.getVersion();
        String reason = dependency.getReason();
        Object[] objectArray = new Object[6];
        objectArray[0] = dependency.getClass().getName();
        objectArray[1] = group != null ? group + ':' : "";
        objectArray[2] = dependency.getName();
        objectArray[3] = version != null ? ':' + version : "";
        Object object = objectArray[4] = reason != null ? " (" + reason + ')' : "";
        if (dependency instanceof FileCollectionDependency) {
            Object[] objectArray2 = new Object[1];
            objectArray2[0] = String.join((CharSequence)", ", ((FileCollectionDependency)dependency).getFiles().getFiles().stream().map(File::getAbsolutePath).map(CharSequence.class::cast)::iterator);
            string = String.format(" [%s]", objectArray2);
        } else {
            string = "";
        }
        objectArray[5] = string;
        return String.format("(%s) %s%s%s%s%s", objectArray);
    }

    public static <P extends Property<?>> Closure<P> finalizeProperty() {
        Closure ret = Closures.unaryOperator(SharedUtil::finalizeProperty);
        ret.setResolveStrategy(1);
        return ret;
    }

    @Contract(value="_ -> param1", mutates="param1")
    public static <P extends Property<?>> P finalizeProperty(P property) {
        property.disallowChanges();
        property.finalizeValueOnRead();
        return property;
    }

    protected SharedUtil() {
    }
}

