/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.util.Objects;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.EnhancedProblems;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Lazy;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gradleutils.shared.Tool;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.gradle.StartParameter;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.BuildLayout;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

public abstract class EnhancedPlugin<T>
implements Plugin<T> {
    private final String name;
    private final String displayName;
    private T target;
    private final EnhancedProblems problemsInternal;
    private final Lazy<DirectoryProperty> globalCaches = Lazy.simple(this::makeGlobalCaches);
    private final Lazy<DirectoryProperty> localCaches = Lazy.simple(this::makeLocalCaches);

    @Inject
    protected abstract ObjectFactory getObjects();

    @Inject
    protected abstract BuildLayout getBuildLayout();

    @Inject
    protected abstract ProviderFactory getProviders();

    protected EnhancedPlugin(String name, String displayName) {
        this.name = name;
        this.displayName = displayName;
        this.problemsInternal = (EnhancedProblems)this.getObjects().newInstance(EnhancedProblems.Minimal.class, new Object[]{name, displayName});
    }

    public final void apply(T target) {
        this.target = target;
        this.setup(this.target);
    }

    public abstract void setup(T var1);

    private T getTarget() {
        try {
            return Objects.requireNonNull(this.target);
        }
        catch (Exception e) {
            throw this.problemsInternal.pluginNotYetApplied(e);
        }
    }

    final EnhancedProblems getProblemsInternal() {
        return this.problemsInternal;
    }

    public Provider<File> getTool(Tool tool) {
        return tool.get((Provider<? extends Directory>)this.globalCaches(), this.getProviders());
    }

    public final DirectoryProperty globalCaches() {
        return this.globalCaches.get();
    }

    private DirectoryProperty makeGlobalCaches() {
        try {
            StartParameter startParameter = ((Gradle)InvokerHelper.getPropertySafe(this.target, (String)"gradle")).getStartParameter();
            DirectoryProperty gradleUserHomeDir = this.getObjects().directoryProperty().fileValue(startParameter.getGradleUserHomeDir());
            return this.getObjects().directoryProperty().convention(gradleUserHomeDir.dir("caches/minecraftforge/" + this.name).map(this.problemsInternal.ensureFileLocation()));
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException(String.format("Failed to get %s global caches directory for target: %s", this.displayName, this.target), e), "types with access to Gradle (#getGradle()Lorg/gradle/api/invocation/Gradle), such as projects or settings.");
        }
    }

    public final DirectoryProperty localCaches() {
        return this.localCaches.get();
    }

    private DirectoryProperty makeLocalCaches() {
        try {
            DirectoryProperty workingProjectBuildDir;
            if (this.target instanceof Project) {
                workingProjectBuildDir = ((Project)this.target).getLayout().getBuildDirectory();
            } else {
                StartParameter startParameter = ((Gradle)InvokerHelper.getPropertySafe(this.target, (String)"gradle")).getStartParameter();
                File projectDir = startParameter.getProjectDir();
                workingProjectBuildDir = this.getObjects().directoryProperty().fileValue(new File(projectDir != null ? projectDir : this.getBuildLayout().getRootDirectory().getAsFile(), "build"));
            }
            return this.getObjects().directoryProperty().convention(workingProjectBuildDir.dir("minecraftforge/" + this.name).map(this.problemsInternal.ensureFileLocation()));
        }
        catch (Exception e) {
            throw this.problemsInternal.illegalPluginTarget(new IllegalArgumentException(String.format("Failed to get %s local caches directory for target: %s", this.displayName, this.getTarget()), e), "projects or types with access to Gradle (#getGradle()Lorg/gradle/api/invocation/Gradle), such as settings.");
        }
    }
}

