/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shared;

import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.util.download.DownloadUtils;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.util.hash.HashStore;
import net.minecraftforge.gradleutils.shared.Tool;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.jetbrains.annotations.Nullable;

record ToolImpl(String getName, String version, String fileName, String downloadUrl, int getJavaVersion, @Nullable String getMainClass) implements Tool
{
    private static final Logger LOGGER = Logging.getLogger(Tool.class);

    ToolImpl(String name, String version, String downloadUrl, int javaVersion, @Nullable String mainClass) {
        this(name, version, "%s-%s.jar".formatted(name, version), downloadUrl, javaVersion, mainClass);
    }

    @Override
    public Provider<File> get(Provider<? extends Directory> cachesDir, ProviderFactory providers) {
        return providers.of(Source.class, spec -> spec.parameters(parameters -> {
            parameters.getInputFile().set(cachesDir.map(d -> d.file("tools/" + this.fileName)));
            parameters.getDownloadUrl().set((Object)this.downloadUrl);
        }));
    }

    static abstract class Source
    implements ValueSource<File, Parameters> {
        @Inject
        public Source() {
        }

        public File obtain() {
            Parameters parameters = (Parameters)this.getParameters();
            String downloadUrl = (String)parameters.getDownloadUrl().get();
            File outFile = ((RegularFile)parameters.getInputFile().get()).getAsFile();
            String name = outFile.getName();
            HashStore cache = HashStore.fromFile(outFile).add("url", downloadUrl);
            if (outFile.exists() && cache.isSame()) {
                LOGGER.info("Default tool already downloaded: {}", (Object)name);
            } else {
                LOGGER.info("Downloading default tool: {}", (Object)name);
                try {
                    DownloadUtils.downloadFile(outFile, downloadUrl);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to download default tool: " + name, e);
                }
                cache.save();
            }
            return outFile;
        }

        static interface Parameters
        extends ValueSourceParameters {
            public RegularFileProperty getInputFile();

            public Property<String> getDownloadUrl();
        }
    }
}

