/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.SignatureVerifier;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.SignatureVerifierFactory;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevObject;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevTag;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.RawParseUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureVerifiers {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureVerifiers.class);
    private static final byte[] PGP_PREFIX = "-----BEGIN PGP SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] X509_PREFIX = "-----BEGIN SIGNED MESSAGE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] SSH_PREFIX = "-----BEGIN SSH SIGNATURE-----".getBytes(StandardCharsets.US_ASCII);
    private static final Map<GpgConfig.GpgFormat, SignatureVerifierFactory> FACTORIES = SignatureVerifiers.loadSignatureVerifiers();
    private static final Map<GpgConfig.GpgFormat, SignatureVerifier> VERIFIERS = new ConcurrentHashMap<GpgConfig.GpgFormat, SignatureVerifier>();

    private static Map<GpgConfig.GpgFormat, SignatureVerifierFactory> loadSignatureVerifiers() {
        EnumMap<GpgConfig.GpgFormat, SignatureVerifierFactory> result = new EnumMap<GpgConfig.GpgFormat, SignatureVerifierFactory>(GpgConfig.GpgFormat.class);
        try {
            for (SignatureVerifierFactory factory : ServiceLoader.load(SignatureVerifierFactory.class)) {
                GpgConfig.GpgFormat format = factory.getType();
                SignatureVerifierFactory existing = (SignatureVerifierFactory)result.get(format);
                if (existing != null) {
                    LOG.warn("{}", (Object)MessageFormat.format(JGitText.get().signatureServiceConflict, "SignatureVerifierFactory", format, existing.getClass().getCanonicalName(), factory.getClass().getCanonicalName()));
                    continue;
                }
                result.put(format, factory);
            }
        }
        catch (ServiceConfigurationError e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private SignatureVerifiers() {
    }

    public static SignatureVerifier get(@NonNull GpgConfig.GpgFormat format) {
        return VERIFIERS.computeIfAbsent(format, f -> {
            SignatureVerifierFactory factory = FACTORIES.get(format);
            if (factory == null) {
                return null;
            }
            return factory.create();
        });
    }

    public static void set(@NonNull GpgConfig.GpgFormat format, SignatureVerifier verifier) {
        SignatureVerifier previous = verifier == null ? VERIFIERS.remove(format) : VERIFIERS.put(format, verifier);
        if (previous != null) {
            previous.clear();
        }
    }

    @Nullable
    public static SignatureVerifier.SignatureVerification verify(@NonNull Repository repository, @NonNull GpgConfig config, @NonNull RevObject object) throws IOException {
        if (object instanceof RevCommit) {
            RevCommit commit = (RevCommit)object;
            byte[] signatureData = commit.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = commit.getRawBuffer();
            byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
            int start = RawParseUtils.headerStart(header, raw, 0);
            if (start < 0) {
                return null;
            }
            int end = RawParseUtils.nextLfSkippingSplitLines(raw, start);
            start -= header.length + 1;
            if (end < raw.length) {
                ++end;
            }
            byte[] data = new byte[raw.length - (end - start)];
            System.arraycopy(raw, 0, data, 0, start);
            System.arraycopy(raw, end, data, start, raw.length - end);
            return SignatureVerifiers.verify(repository, config, data, signatureData);
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            byte[] signatureData = tag.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = tag.getRawBuffer();
            byte[] data = Arrays.copyOfRange(raw, 0, raw.length - signatureData.length);
            return SignatureVerifiers.verify(repository, config, data, signatureData);
        }
        return null;
    }

    @Nullable
    public static SignatureVerifier.SignatureVerification verify(@NonNull Repository repository, @NonNull GpgConfig config, byte[] data, byte[] signature) throws IOException {
        GpgConfig.GpgFormat format = SignatureVerifiers.getFormat(signature);
        if (format == null) {
            return null;
        }
        SignatureVerifier verifier = SignatureVerifiers.get(format);
        if (verifier == null) {
            return null;
        }
        return verifier.verify(repository, config, data, signature);
    }

    @Nullable
    public static GpgConfig.GpgFormat getFormat(byte[] signature) {
        if (RawParseUtils.match(signature, 0, PGP_PREFIX) > 0) {
            return GpgConfig.GpgFormat.OPENPGP;
        }
        if (RawParseUtils.match(signature, 0, X509_PREFIX) > 0) {
            return GpgConfig.GpgFormat.X509;
        }
        if (RawParseUtils.match(signature, 0, SSH_PREFIX) > 0) {
            return GpgConfig.GpgFormat.SSH;
        }
        return null;
    }
}

