/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.LogCursor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.Reftable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogEntry;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogReader;

public class ReftableReflogReader
implements ReflogReader {
    private final Lock lock;
    private final Reftable reftable;
    private final String refname;

    ReftableReflogReader(Lock lock, Reftable merged, String refname) {
        this.lock = lock;
        this.reftable = merged;
        this.refname = refname;
    }

    @Override
    public ReflogEntry getLastEntry() throws IOException {
        this.lock.lock();
        try {
            LogCursor cursor = this.reftable.seekLog(this.refname);
            ReflogEntry reflogEntry = cursor.next() ? cursor.getReflogEntry() : null;
            return reflogEntry;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<ReflogEntry> getReverseEntries() throws IOException {
        return this.getReverseEntries(Integer.MAX_VALUE);
    }

    @Override
    public ReflogEntry getReverseEntry(int number) throws IOException {
        this.lock.lock();
        try {
            LogCursor cursor = this.reftable.seekLog(this.refname);
            while (true) {
                if (!cursor.next() || number < 0) {
                    return null;
                }
                if (number == 0) {
                    ReflogEntry reflogEntry = cursor.getReflogEntry();
                    return reflogEntry;
                }
                --number;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<ReflogEntry> getReverseEntries(int max) throws IOException {
        this.lock.lock();
        try {
            LogCursor cursor = this.reftable.seekLog(this.refname);
            ArrayList<ReflogEntry> result = new ArrayList<ReflogEntry>();
            while (cursor.next() && result.size() < max) {
                result.add(cursor.getReflogEntry());
            }
            ArrayList<ReflogEntry> arrayList = result;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }
}

