/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.BlockSizeTooSmallException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableConstants;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableOutputStream;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.PersonIdent;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.IntList;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.LongList;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.NB;

class BlockWriter {
    private final byte blockType;
    private final byte keyType;
    private final List<Entry> entries;
    private final int blockLimitBytes;
    private final int restartInterval;
    private int entriesSumBytes;
    private int restartCnt;

    BlockWriter(byte type, byte kt, int bs, int ri) {
        this.blockType = type;
        this.keyType = kt;
        this.blockLimitBytes = bs;
        this.restartInterval = ri;
        this.entries = new ArrayList<Entry>(BlockWriter.estimateEntryCount(type, kt, bs));
    }

    private static int estimateEntryCount(byte blockType, byte keyType, int blockLimitBytes) {
        int cnt = (int)Math.ceil((double)blockLimitBytes / (switch (blockType) {
            default -> 35.31;
            case 111 -> 4.19;
            case 103 -> 101.14;
            case 105 -> {
                switch (keyType) {
                    default: {
                        yield 27.44;
                    }
                    case 111: 
                }
                yield 11.57;
            }
        }));
        return Math.min(cnt, 4096);
    }

    byte blockType() {
        return this.blockType;
    }

    boolean padBetweenBlocks() {
        return BlockWriter.padBetweenBlocks(this.blockType) || this.blockType == 105 && BlockWriter.padBetweenBlocks(this.keyType);
    }

    static boolean padBetweenBlocks(byte type) {
        return type == 114 || type == 111;
    }

    byte[] lastKey() {
        return this.entries.get((int)(this.entries.size() - 1)).key;
    }

    int currentSize() {
        return this.computeBlockBytes(0, false);
    }

    void mustAdd(Entry entry) throws BlockSizeTooSmallException {
        if (!this.tryAdd(entry, true)) {
            throw this.blockSizeTooSmall(entry);
        }
    }

    boolean tryAdd(Entry entry) {
        if (entry instanceof ObjEntry && BlockWriter.computeBlockBytes(entry.sizeBytes(), 1) > this.blockLimitBytes) {
            ((ObjEntry)entry).markScanRequired();
        }
        if (this.tryAdd(entry, true)) {
            return true;
        }
        if (this.nextShouldBeRestart()) {
            return this.tryAdd(entry, false);
        }
        return false;
    }

    private boolean tryAdd(Entry entry, boolean tryRestart) {
        boolean restart;
        byte[] key = entry.key;
        int prefixLen = 0;
        boolean bl = restart = tryRestart && this.nextShouldBeRestart();
        if (!restart) {
            Entry priorEntry = this.entries.get(this.entries.size() - 1);
            byte[] prior = priorEntry.key;
            prefixLen = BlockWriter.commonPrefix(prior, prior.length, key);
            if (prefixLen <= 5 && this.keyType == 114) {
                restart = true;
                prefixLen = 0;
            } else if (prefixLen == 0) {
                restart = true;
            }
        }
        entry.restart = restart;
        entry.prefixLen = prefixLen;
        int entryBytes = entry.sizeBytes();
        if (this.computeBlockBytes(entryBytes, restart) > this.blockLimitBytes) {
            return false;
        }
        this.entriesSumBytes += entryBytes;
        this.entries.add(entry);
        if (restart) {
            ++this.restartCnt;
        }
        return true;
    }

    private boolean nextShouldBeRestart() {
        int cnt = this.entries.size();
        return (cnt == 0 || (cnt + 1) % this.restartInterval == 0) && this.restartCnt < 65535;
    }

    private int computeBlockBytes(int entryBytes, boolean restart) {
        return BlockWriter.computeBlockBytes(this.entriesSumBytes + entryBytes, this.restartCnt + (restart ? 1 : 0));
    }

    private static int computeBlockBytes(int entryBytes, int restartCnt) {
        return 4 + entryBytes + restartCnt * 3 + 2;
    }

    void writeTo(ReftableOutputStream os) throws IOException {
        os.beginBlock(this.blockType);
        IntList restarts = new IntList(this.restartCnt);
        for (Entry entry : this.entries) {
            if (entry.restart) {
                restarts.add(os.bytesWrittenInBlock());
            }
            entry.writeKey(os);
            entry.writeValue(os);
        }
        if (restarts.size() == 0 || restarts.size() > 65535) {
            throw new IllegalStateException();
        }
        int i = 0;
        while (i < restarts.size()) {
            os.writeInt24(restarts.get(i));
            ++i;
        }
        os.writeInt16(restarts.size());
        os.flushBlock();
    }

    private BlockSizeTooSmallException blockSizeTooSmall(Entry entry) {
        int min2 = 24 + BlockWriter.computeBlockBytes(entry.sizeBytes(), 1);
        return new BlockSizeTooSmallException(min2);
    }

    static int commonPrefix(byte[] a, int n, byte[] b) {
        int len = Math.min(n, Math.min(a.length, b.length));
        int i = 0;
        while (i < len) {
            if (a[i] != b[i]) {
                return i;
            }
            ++i;
        }
        return len;
    }

    static int encodeSuffixAndType(int sfx, int valueType) {
        return sfx << 3 | valueType;
    }

    static int compare(byte[] a, int ai, int aLen, byte[] b, int bi, int bLen) {
        int aEnd = ai + aLen;
        int bEnd = bi + bLen;
        while (ai < aEnd && bi < bEnd) {
            int c;
            if ((c = (a[ai++] & 0xFF) - (b[bi++] & 0xFF)) == 0) continue;
            return c;
        }
        return aLen - bLen;
    }

    static class DeleteLogEntry
    extends Entry {
        DeleteLogEntry(String refName, long updateIndex) {
            super(LogEntry.key(refName, updateIndex));
        }

        @Override
        byte blockType() {
            return 103;
        }

        @Override
        int valueType() {
            return 0;
        }

        @Override
        int valueSize() {
            return 0;
        }

        @Override
        void writeValue(ReftableOutputStream os) {
        }
    }

    static abstract class Entry {
        final byte[] key;
        int prefixLen;
        boolean restart;

        static int compare(Entry ea, Entry eb) {
            byte[] a = ea.key;
            byte[] b = eb.key;
            return BlockWriter.compare(a, 0, a.length, b, 0, b.length);
        }

        Entry(byte[] key) {
            this.key = key;
        }

        void writeKey(ReftableOutputStream os) {
            int sfxLen = this.key.length - this.prefixLen;
            os.writeVarint(this.prefixLen);
            os.writeVarint(BlockWriter.encodeSuffixAndType(sfxLen, this.valueType()));
            os.write(this.key, this.prefixLen, sfxLen);
        }

        int sizeBytes() {
            int sfxLen = this.key.length - this.prefixLen;
            int sfx = BlockWriter.encodeSuffixAndType(sfxLen, this.valueType());
            return ReftableOutputStream.computeVarintSize(this.prefixLen) + ReftableOutputStream.computeVarintSize(sfx) + sfxLen + this.valueSize();
        }

        abstract byte blockType();

        abstract int valueType();

        abstract int valueSize();

        abstract void writeValue(ReftableOutputStream var1) throws IOException;
    }

    static class IndexEntry
    extends Entry {
        private final long blockPosition;

        IndexEntry(byte[] key, long blockPosition) {
            super(key);
            this.blockPosition = blockPosition;
        }

        @Override
        byte blockType() {
            return 105;
        }

        @Override
        int valueType() {
            return 0;
        }

        @Override
        int valueSize() {
            return ReftableOutputStream.computeVarintSize(this.blockPosition);
        }

        @Override
        void writeValue(ReftableOutputStream os) {
            os.writeVarint(this.blockPosition);
        }
    }

    static class LogEntry
    extends Entry {
        final ObjectId oldId;
        final ObjectId newId;
        final long timeSecs;
        final short tz;
        final byte[] name;
        final byte[] email;
        final byte[] msg;

        LogEntry(String refName, long updateIndex, PersonIdent who, ObjectId oldId, ObjectId newId, String message) {
            super(LogEntry.key(refName, updateIndex));
            this.oldId = oldId;
            this.newId = newId;
            this.timeSecs = who.getWhen().getTime() / 1000L;
            this.tz = (short)who.getTimeZoneOffset();
            this.name = who.getName().getBytes(StandardCharsets.UTF_8);
            this.email = who.getEmailAddress().getBytes(StandardCharsets.UTF_8);
            this.msg = message.getBytes(StandardCharsets.UTF_8);
        }

        static byte[] key(String ref, long index) {
            byte[] name = ref.getBytes(StandardCharsets.UTF_8);
            byte[] key = Arrays.copyOf(name, name.length + 1 + 8);
            NB.encodeInt64(key, key.length - 8, ReftableConstants.reverseUpdateIndex(index));
            return key;
        }

        @Override
        byte blockType() {
            return 103;
        }

        @Override
        int valueType() {
            return 1;
        }

        @Override
        int valueSize() {
            return 40 + ReftableOutputStream.computeVarintSize(this.name.length) + this.name.length + ReftableOutputStream.computeVarintSize(this.email.length) + this.email.length + ReftableOutputStream.computeVarintSize(this.timeSecs) + 2 + ReftableOutputStream.computeVarintSize(this.msg.length) + this.msg.length;
        }

        @Override
        void writeValue(ReftableOutputStream os) {
            os.writeId(this.oldId);
            os.writeId(this.newId);
            os.writeVarintString(this.name);
            os.writeVarintString(this.email);
            os.writeVarint(this.timeSecs);
            os.writeInt16(this.tz);
            os.writeVarintString(this.msg);
        }
    }

    static class ObjEntry
    extends Entry {
        final LongList blockPos;

        ObjEntry(int idLen, ObjectId id, LongList blockPos) {
            super(ObjEntry.key(idLen, id));
            this.blockPos = blockPos;
        }

        private static byte[] key(int idLen, ObjectId id) {
            byte[] key = new byte[20];
            id.copyRawTo(key, 0);
            if (idLen < 20) {
                return Arrays.copyOf(key, idLen);
            }
            return key;
        }

        void markScanRequired() {
            this.blockPos.clear();
        }

        @Override
        byte blockType() {
            return 111;
        }

        @Override
        int valueType() {
            int cnt = this.blockPos.size();
            return cnt != 0 && cnt <= 7 ? cnt : 0;
        }

        @Override
        int valueSize() {
            int cnt = this.blockPos.size();
            if (cnt == 0) {
                return ReftableOutputStream.computeVarintSize(0L);
            }
            int n = 0;
            if (cnt > 7) {
                n += ReftableOutputStream.computeVarintSize(cnt);
            }
            n += ReftableOutputStream.computeVarintSize(this.blockPos.get(0));
            int j = 1;
            while (j < cnt) {
                long prior = this.blockPos.get(j - 1);
                long b = this.blockPos.get(j);
                n += ReftableOutputStream.computeVarintSize(b - prior);
                ++j;
            }
            return n;
        }

        @Override
        void writeValue(ReftableOutputStream os) throws IOException {
            int cnt = this.blockPos.size();
            if (cnt == 0) {
                os.writeVarint(0L);
                return;
            }
            if (cnt > 7) {
                os.writeVarint(cnt);
            }
            os.writeVarint(this.blockPos.get(0));
            int j = 1;
            while (j < cnt) {
                long prior = this.blockPos.get(j - 1);
                long b = this.blockPos.get(j);
                os.writeVarint(b - prior);
                ++j;
            }
        }
    }

    static class RefEntry
    extends Entry {
        final Ref ref;
        final long updateIndexDelta;

        RefEntry(Ref ref, long updateIndexDelta) {
            super(RefEntry.nameUtf8(ref));
            this.ref = ref;
            this.updateIndexDelta = updateIndexDelta;
        }

        @Override
        byte blockType() {
            return 114;
        }

        @Override
        int valueType() {
            if (this.ref.isSymbolic()) {
                return 3;
            }
            if (this.ref.getStorage() == Ref.Storage.NEW && this.ref.getObjectId() == null) {
                return 0;
            }
            if (this.ref.getPeeledObjectId() != null) {
                return 2;
            }
            return 1;
        }

        @Override
        int valueSize() {
            int n = ReftableOutputStream.computeVarintSize(this.updateIndexDelta);
            switch (this.valueType()) {
                case 0: {
                    return n;
                }
                case 1: {
                    return n + 20;
                }
                case 2: {
                    return n + 40;
                }
                case 3: {
                    if (!this.ref.isSymbolic()) break;
                    int nameLen = RefEntry.nameUtf8(this.ref.getTarget()).length;
                    return n + ReftableOutputStream.computeVarintSize(nameLen) + nameLen;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        void writeValue(ReftableOutputStream os) throws IOException {
            os.writeVarint(this.updateIndexDelta);
            switch (this.valueType()) {
                case 0: {
                    return;
                }
                case 1: {
                    ObjectId id1 = this.ref.getObjectId();
                    if (!this.ref.isPeeled()) {
                        throw new IOException(JGitText.get().peeledRefIsRequired);
                    }
                    if (id1 == null) {
                        throw new IOException(JGitText.get().invalidId0);
                    }
                    os.writeId(id1);
                    return;
                }
                case 2: {
                    ObjectId id1 = this.ref.getObjectId();
                    ObjectId id2 = this.ref.getPeeledObjectId();
                    if (!this.ref.isPeeled()) {
                        throw new IOException(JGitText.get().peeledRefIsRequired);
                    }
                    if (id1 == null || id2 == null) {
                        throw new IOException(JGitText.get().invalidId0);
                    }
                    os.writeId(id1);
                    os.writeId(id2);
                    return;
                }
                case 3: {
                    if (!this.ref.isSymbolic()) break;
                    os.writeVarintString(this.ref.getTarget().getName());
                    return;
                }
            }
            throw new IllegalStateException();
        }

        private static byte[] nameUtf8(Ref ref) {
            return ref.getName().getBytes(StandardCharsets.UTF_8);
        }
    }
}

