/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackedBatchRefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectory;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectoryRename;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.RefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;

class SnapshottingRefDirectory
extends RefDirectory {
    final RefDirectory refDb;
    private final Set<File> refreshedLooseRefDirs = ConcurrentHashMap.newKeySet();
    private volatile boolean isValid;

    SnapshottingRefDirectory(RefDirectory refDb) {
        super(refDb);
        this.refDb = refDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    RefDirectory.PackedRefList getPackedRefs() throws IOException {
        if (!this.isValid) {
            SnapshottingRefDirectory snapshottingRefDirectory = this;
            synchronized (snapshottingRefDirectory) {
                if (!this.isValid) {
                    this.refreshSnapshot();
                }
            }
        }
        return (RefDirectory.PackedRefList)this.packedRefs.get();
    }

    @Override
    void refreshPathToLooseRef(Path refPath) {
        int i = 1;
        while (i < refPath.getNameCount()) {
            File dir = this.fileFor(refPath.subpath(0, i).toString());
            if (!this.refreshedLooseRefDirs.contains(dir)) {
                try {
                    try {
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try {
                            InputStream stream = Files.newInputStream(dir.toPath(), new OpenOption[0]);
                            if (stream != null) {
                                stream.close();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        this.refreshedLooseRefDirs.add(dir);
                        break;
                    }
                }
                finally {
                    this.refreshedLooseRefDirs.add(dir);
                }
            }
            ++i;
        }
    }

    @Override
    void delete(RefDirectoryUpdate update) throws IOException {
        this.refreshSnapshot();
        super.delete(update);
    }

    @Override
    public RefDirectoryUpdate newUpdate(String name, boolean detach) throws IOException {
        this.refreshSnapshot();
        return super.newUpdate(name, detach);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate() {
        return new SnapshotPackedBatchRefUpdate(this);
    }

    @Override
    public PackedBatchRefUpdate newBatchUpdate(boolean shouldLockLooseRefs) {
        return new SnapshotPackedBatchRefUpdate(this, shouldLockLooseRefs);
    }

    @Override
    RefDirectoryUpdate newTemporaryUpdate() throws IOException {
        this.refreshSnapshot();
        return super.newTemporaryUpdate();
    }

    @Override
    RefDirectoryUpdate createRefDirectoryUpdate(Ref ref) {
        return new SnapshotRefDirectoryUpdate(this, ref);
    }

    @Override
    RefDirectoryRename createRefDirectoryRename(RefDirectoryUpdate from, RefDirectoryUpdate to) {
        return new SnapshotRefDirectoryRename(from, to);
    }

    synchronized void invalidateSnapshot() {
        this.refreshedLooseRefDirs.clear();
        this.isValid = false;
    }

    private synchronized void refreshSnapshot() throws IOException {
        this.compareAndSetPackedRefs((RefDirectory.PackedRefList)this.packedRefs.get(), this.refDb.getPackedRefs());
        this.isValid = true;
    }

    private static <T> T invalidateSnapshotOnError(SupplierThrowsException<T, IOException> f, SnapshottingRefDirectory refDb) throws IOException {
        return (T)SnapshottingRefDirectory.invalidateSnapshotOnError(a -> f.call(), null, refDb);
    }

    private static <A, R> R invalidateSnapshotOnError(FunctionThrowsException<A, R, IOException> f, A a, SnapshottingRefDirectory refDb) throws IOException {
        try {
            return f.apply(a);
        }
        catch (IOException e) {
            refDb.invalidateSnapshot();
            throw e;
        }
    }

    private static <A1, A2, A3> void invalidateSnapshotOnError(TriConsumerThrowsException<A1, A2, A3, IOException> f, A1 a1, A2 a2, A3 a3, SnapshottingRefDirectory refDb) throws IOException {
        try {
            f.accept(a1, a2, a3);
        }
        catch (IOException e) {
            refDb.invalidateSnapshot();
            throw e;
        }
    }

    @FunctionalInterface
    private static interface FunctionThrowsException<A, R, E extends Exception> {
        public R apply(A var1) throws E;
    }

    private static class SnapshotPackedBatchRefUpdate
    extends PackedBatchRefUpdate {
        SnapshotPackedBatchRefUpdate(RefDirectory refDb) {
            super(refDb);
        }

        SnapshotPackedBatchRefUpdate(RefDirectory refDb, boolean shouldLockLooseRefs) {
            super(refDb, shouldLockLooseRefs);
        }

        @Override
        public void execute(RevWalk walk, ProgressMonitor monitor, List<String> options) throws IOException {
            SnapshottingRefDirectory.invalidateSnapshotOnError((revWalk, progressMonitor, list) -> super.execute((RevWalk)revWalk, (ProgressMonitor)progressMonitor, (List<String>)list), walk, monitor, options, this.getRefDatabase());
        }

        @Override
        public void execute(RevWalk walk, ProgressMonitor monitor) throws IOException {
            SnapshottingRefDirectory.invalidateSnapshotOnError((rw, m4, a3) -> super.execute((RevWalk)rw, (ProgressMonitor)m4), walk, monitor, null, this.getRefDatabase());
        }

        @Override
        public SnapshottingRefDirectory getRefDatabase() {
            return (SnapshottingRefDirectory)super.getRefDatabase();
        }
    }

    private static class SnapshotRefDirectoryRename
    extends RefDirectoryRename {
        SnapshotRefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
            super(src, dst);
        }

        @Override
        public RefUpdate.Result rename() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.rename(), this.getRefDirectory());
        }

        @Override
        public SnapshottingRefDirectory getRefDirectory() {
            return (SnapshottingRefDirectory)super.getRefDirectory();
        }
    }

    private static class SnapshotRefDirectoryUpdate
    extends RefDirectoryUpdate {
        SnapshotRefDirectoryUpdate(RefDirectory r, Ref ref) {
            super(r, ref);
        }

        @Override
        public RefUpdate.Result forceUpdate() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.forceUpdate(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result update() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.update(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result update(RevWalk walk) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(revWalk -> super.update((RevWalk)revWalk), walk, this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result delete() throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(() -> super.delete(), this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result delete(RevWalk walk) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(revWalk -> super.delete((RevWalk)revWalk), walk, this.getRefDatabase());
        }

        @Override
        public RefUpdate.Result link(String target) throws IOException {
            return SnapshottingRefDirectory.invalidateSnapshotOnError(string -> super.link((String)string), target, this.getRefDatabase());
        }

        @Override
        protected void doAfterLocking(String name) {
            this.getRefDatabase().invalidateSnapshot();
        }

        @Override
        public SnapshottingRefDirectory getRefDatabase() {
            return (SnapshottingRefDirectory)super.getRefDatabase();
        }
    }

    @FunctionalInterface
    private static interface SupplierThrowsException<R, E extends Exception> {
        public R call() throws E;
    }

    @FunctionalInterface
    private static interface TriConsumerThrowsException<A1, A2, A3, E extends Exception> {
        public void accept(A1 var1, A2 var2, A3 var3) throws E;
    }
}

