/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph;

import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.commitgraph.ChangedPathFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.NB;

class GraphChangedPathFilterData {
    private static final int BIDX_BYTES_PER_ENTRY = 4;
    private static final int BDAT_HEADER_BYTES = 12;
    private final byte[] bloomFilterIndex;
    private final byte[] bloomFilterData;

    GraphChangedPathFilterData(byte[] bloomFilterIndex, byte[] bloomFilterData) {
        if (bloomFilterIndex == null != (bloomFilterData == null)) {
            bloomFilterIndex = null;
            bloomFilterData = null;
        }
        if (bloomFilterData != null && (NB.decodeUInt32(bloomFilterData, 4) != 7L || NB.decodeUInt32(bloomFilterData, 8) != 10L)) {
            bloomFilterIndex = null;
            bloomFilterData = null;
        }
        this.bloomFilterIndex = bloomFilterIndex;
        this.bloomFilterData = bloomFilterData;
    }

    ChangedPathFilter getChangedPathFilter(int graphPos) {
        if (this.bloomFilterIndex == null) {
            return null;
        }
        int priorCumul = graphPos == 0 ? 0 : NB.decodeInt32(this.bloomFilterIndex, graphPos * 4 - 4);
        int cumul = NB.decodeInt32(this.bloomFilterIndex, graphPos * 4);
        return ChangedPathFilter.fromFile(this.bloomFilterData, priorCumul + 12, cumul - priorCumul);
    }
}

