/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.blame;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.blame.Candidate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.blame.Region;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.blame.cache.CacheRegion;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.filter.PathFilter;

class BlameRegionMerger {
    private final Repository repo;
    private final List<CacheRegion> cachedRegions;
    private final RevWalk rw;

    BlameRegionMerger(Repository repo, RevWalk rw, List<CacheRegion> cachedRegions) {
        this.repo = repo;
        ArrayList<CacheRegion> sorted = new ArrayList<CacheRegion>(cachedRegions);
        Collections.sort(sorted);
        this.cachedRegions = sorted;
        this.rw = rw;
    }

    Candidate mergeCandidate(Candidate candidate) {
        ArrayList<Candidate> newCandidates = new ArrayList<Candidate>();
        Region r = candidate.regionList;
        while (r != null) {
            try {
                newCandidates.addAll(this.mergeOneRegion(r));
            }
            catch (IOException e) {
                return null;
            }
            r = r.next;
        }
        return BlameRegionMerger.asLinkedCandidate(newCandidates);
    }

    List<Candidate> mergeOneRegion(Region region) throws IOException {
        List<CacheRegion> overlaps = this.findOverlaps(region);
        if (overlaps.isEmpty()) {
            throw new IOException("Cached blame should cover all lines");
        }
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (CacheRegion overlap : overlaps) {
            Region blamedRegions = BlameRegionMerger.intersectRegions(region, overlap);
            Candidate c = new Candidate(this.repo, this.parse(overlap.getSourceCommit()), PathFilter.create(overlap.getSourcePath()));
            c.regionList = blamedRegions;
            candidates.add(c);
        }
        return candidates;
    }

    List<CacheRegion> findOverlaps(Region unblamed) {
        int unblamedStart = unblamed.sourceStart;
        int unblamedEnd = unblamedStart + unblamed.length;
        ArrayList<CacheRegion> overlapping = new ArrayList<CacheRegion>();
        for (CacheRegion blamed : this.cachedRegions) {
            if (blamed.getEnd() <= unblamedStart) continue;
            if (blamed.getStart() >= unblamedEnd) break;
            overlapping.add(blamed);
        }
        return overlapping;
    }

    static Region intersectRegions(Region unblamed, CacheRegion cached) {
        int blamedStart = Math.max(cached.getStart(), unblamed.sourceStart);
        int blamedEnd = Math.min(cached.getEnd(), unblamed.sourceStart + unblamed.length);
        int length = blamedEnd - blamedStart;
        int blameStartDelta = blamedStart - unblamed.sourceStart;
        return new Region(unblamed.resultStart + blameStartDelta, blamedStart, length);
    }

    protected RevCommit parse(ObjectId oid) throws IOException {
        return this.rw.parseCommit(oid);
    }

    private static Candidate asLinkedCandidate(List<Candidate> c) {
        Candidate head;
        Candidate tail = head = c.get(0);
        int i = 1;
        while (i < c.size()) {
            tail = tail.queueNext = c.get(i);
            ++i;
        }
        return head;
    }
}

