/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.IOException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.NullProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;

public class PackRefsCommand
extends GitCommand<String> {
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean all;

    public PackRefsCommand(Repository repo) {
        super(repo);
    }

    public PackRefsCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public PackRefsCommand setAll(boolean all) {
        this.all = all;
        return this;
    }

    public boolean isAll() {
        return this.all;
    }

    @Override
    public String call() throws GitAPIException {
        this.checkCallable();
        try {
            this.repo.getRefDatabase().packRefs(this.monitor, this);
            return JGitText.get().packRefsSuccessful;
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().packRefsFailed, e);
        }
    }
}

