/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.FooterLine;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;

public interface CherryPickCommitMessageProvider {
    public static final CherryPickCommitMessageProvider ORIGINAL = RevCommit::getFullMessage;
    public static final CherryPickCommitMessageProvider ORIGINAL_WITH_REFERENCE = srcCommit -> {
        String fullMessage = srcCommit.getFullMessage();
        String separator = CherryPickCommitMessageProvider.messageEndsWithFooter(srcCommit) ? "\n" : "\n\n";
        String revisionString = srcCommit.getName();
        return String.format("%s%s(cherry picked from commit %s)", fullMessage, separator, revisionString);
    };

    public String getCherryPickedCommitMessage(RevCommit var1);

    private static boolean messageEndsWithFooter(RevCommit srcCommit) {
        List<FooterLine> footers;
        int maxFooterEnd;
        byte[] rawBuffer = srcCommit.getRawBuffer();
        return rawBuffer.length == (maxFooterEnd = (footers = srcCommit.getFooterLines()).stream().mapToInt(FooterLine::getEndOffset).max().orElse(-1));
    }
}

