/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.util.Objects;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;

    public ByteBufferInputStream(@NonNull ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        this.nullCheck();
        if (this.buf.hasRemaining()) {
            return this.buf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.nullCheck();
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.nullCheck();
        Objects.checkFromIndexSize(off, len, b.length);
        if (len == 0) {
            return 0;
        }
        int length = Math.min(this.buf.remaining(), len);
        if (length == 0) {
            return -1;
        }
        this.buf.get(b, off, length);
        return length;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.readNBytes(this.buf.remaining());
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        int l = Math.min(len, this.buf.remaining());
        byte[] b = new byte[l];
        this.read(b);
        return b;
    }

    @Override
    public int readNBytes(byte[] b, int off, int len) throws IOException {
        return this.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.nullCheck();
        if (n <= 0L) {
            return 0L;
        }
        int delta = n > Integer.MAX_VALUE ? this.buf.remaining() : Math.min((int)n, this.buf.remaining());
        this.buf.position(this.buf.position() + delta);
        return delta;
    }

    @Override
    public int available() throws IOException {
        this.nullCheck();
        return this.buf.remaining();
    }

    @Override
    public void close() {
        this.buf = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.buf.reset();
        }
        catch (InvalidMarkException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private void nullCheck() throws IOException {
        if (this.buf == null) {
            throw new IOException(JGitText.get().inputStreamClosed);
        }
    }
}

