/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport;

import java.io.IOException;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.ReceiveCommand;

public interface ReceiveCommandErrorHandler {
    default public void handleNewIdValidationException(ReceiveCommand cmd, IOException e) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getNewId().name());
    }

    default public void handleOldIdValidationException(ReceiveCommand cmd, IOException e) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, cmd.getOldId().name());
    }

    default public void handleFastForwardCheckException(ReceiveCommand cmd, IOException e) {
        if (e instanceof MissingObjectException) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT, e.getMessage());
        } else {
            cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON);
        }
    }

    default public void handleBatchRefUpdateException(List<ReceiveCommand> cmds, IOException e) {
        for (ReceiveCommand cmd : cmds) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            cmd.reject(e);
        }
    }
}

