/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.text.MessageFormat;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.AbstractRevQueue;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.BoundaryGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.DateRevQueue;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.DelayRevQueue;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.DepthGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.DepthWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.FixUninterestingGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.Generator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.LIFORevQueue;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.MergeBaseGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.ObjectWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.PendingGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevSort;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RewriteGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.TopoNonIntermixSortGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.TopoSortGenerator;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.TreeRevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.filter.AndRevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.filter.RevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.filter.TreeFilter;

class StartGenerator
extends Generator {
    private final RevWalk walker;

    StartGenerator(RevWalk w) {
        super(w.isFirstParent());
        this.walker = w;
    }

    @Override
    int outputType() {
        return 0;
    }

    @Override
    RevCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        Generator g2;
        RevWalk w = this.walker;
        RevFilter rf = w.getRevFilter();
        TreeFilter tf = w.getTreeFilter();
        AbstractRevQueue q = this.walker.queue;
        if (rf == RevFilter.MERGE_BASE) {
            if (tf != TreeFilter.ALL) {
                throw new IllegalStateException(MessageFormat.format(JGitText.get().cannotCombineTreeFilterWithRevFilter, tf, rf));
            }
            if (w.isFirstParent()) {
                throw new IllegalStateException(JGitText.get().cannotFindMergeBaseUsingFirstParent);
            }
            MergeBaseGenerator mbg = new MergeBaseGenerator(w);
            this.walker.pending = mbg;
            this.walker.queue = AbstractRevQueue.EMPTY_QUEUE;
            mbg.init(q);
            return mbg.next();
        }
        boolean uninteresting = q.anybodyHasFlag(4);
        boolean boundary = this.walker.hasRevSort(RevSort.BOUNDARY);
        if (!boundary && this.walker instanceof ObjectWalk) {
            boundary = true;
        }
        if (boundary && !uninteresting) {
            boundary = false;
        }
        int pendingOutputType = 0;
        DateRevQueue pending = q instanceof DateRevQueue ? (DateRevQueue)q : RevWalk.newDateRevQueue(q);
        if (tf != TreeFilter.ALL) {
            int rewriteFlag;
            if (w.getRewriteParents()) {
                pendingOutputType |= 6;
                rewriteFlag = 8;
            } else {
                rewriteFlag = 0;
            }
            rf = AndRevFilter.create(new TreeRevFilter(w, tf, rewriteFlag), rf);
        }
        this.walker.queue = q;
        if (this.walker instanceof DepthWalk) {
            DepthWalk dw = (DepthWalk)((Object)this.walker);
            g2 = new DepthGenerator(dw, pending);
        } else {
            g2 = new PendingGenerator(w, pending, rf, pendingOutputType);
            if (this.walker.hasRevSort(RevSort.BOUNDARY)) {
                ((PendingGenerator)g2).canDispose = false;
            }
        }
        if ((g2.outputType() & 4) != 0) {
            g2 = new RewriteGenerator(g2);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER)) {
            throw new IllegalStateException(JGitText.get().cannotCombineTopoSortWithTopoKeepBranchTogetherSort);
        }
        if (this.walker.hasRevSort(RevSort.TOPO) && (g2.outputType() & 8) == 0) {
            g2 = new TopoSortGenerator(g2);
        } else if (this.walker.hasRevSort(RevSort.TOPO_KEEP_BRANCH_TOGETHER) && (g2.outputType() & 8) == 0) {
            g2 = new TopoNonIntermixSortGenerator(g2);
        }
        if (this.walker.hasRevSort(RevSort.REVERSE)) {
            g2 = new LIFORevQueue(g2);
        }
        if (boundary) {
            g2 = new BoundaryGenerator(w, g2);
        } else if (uninteresting) {
            if (pending.peek() != null) {
                g2 = new DelayRevQueue(g2);
            }
            g2 = new FixUninterestingGenerator(g2);
        }
        w.pending = g2;
        return g2.next();
    }
}

