/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.CanceledException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgSignature;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectBuilder;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.PersonIdent;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.CredentialsProvider;

public interface Signer {
    default public void signObject(@NonNull Repository repository, @NonNull GpgConfig config, @NonNull ObjectBuilder object, @NonNull PersonIdent committer, String signingKey, CredentialsProvider credentialsProvider) throws CanceledException, IOException, UnsupportedSigningFormatException {
        try {
            object.setGpgSignature(this.sign(repository, config, object.build(), committer, signingKey, credentialsProvider));
        }
        catch (UnsupportedEncodingException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    public GpgSignature sign(@NonNull Repository var1, @NonNull GpgConfig var2, byte[] var3, @NonNull PersonIdent var4, String var5, CredentialsProvider var6) throws CanceledException, IOException, UnsupportedSigningFormatException;

    public boolean canLocateSigningKey(@NonNull Repository var1, @NonNull GpgConfig var2, @NonNull PersonIdent var3, String var4, CredentialsProvider var5) throws CanceledException;
}

