/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.transport.connectivity;

import java.io.IOException;
import java.util.Set;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectIdSubclassMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.ObjectWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevBlob;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevFlag;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevObject;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevSort;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevTree;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.ConnectivityChecker;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.ReceiveCommand;

public final class FullConnectivityChecker
implements ConnectivityChecker {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void checkConnectivity(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, Set<ObjectId> haves, ProgressMonitor pm) throws MissingObjectException, IOException {
        pm.beginTask(JGitText.get().countingObjects, 0);
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                ObjectWalk ow;
                block13: {
                    ow = new ObjectWalk(connectivityCheckInfo.getRepository());
                    if (this.markStartAndKnownNodes(connectivityCheckInfo, ow, haves, pm)) break block13;
                    if (ow == null) return;
                    ow.close();
                    return;
                }
                try {
                    this.checkCommitTree(connectivityCheckInfo, ow, pm);
                    this.checkObjects(connectivityCheckInfo, ow, pm);
                    return;
                }
                finally {
                    if (ow != null) {
                        ow.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        finally {
            pm.endTask();
        }
    }

    private boolean markStartAndKnownNodes(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, Set<ObjectId> haves, ProgressMonitor pm) throws IOException {
        boolean markTrees;
        boolean bl = markTrees = connectivityCheckInfo.isCheckObjects() && !connectivityCheckInfo.getParser().getBaseObjectIds().isEmpty();
        if (connectivityCheckInfo.isCheckObjects()) {
            ow.sort(RevSort.TOPO);
            if (!connectivityCheckInfo.getParser().getBaseObjectIds().isEmpty()) {
                ow.sort(RevSort.BOUNDARY, true);
            }
        }
        boolean hasInteresting = false;
        for (ReceiveCommand cmd : connectivityCheckInfo.getCommands()) {
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || cmd.getType() == ReceiveCommand.Type.DELETE || haves.contains(cmd.getNewId())) continue;
            ow.markStart(ow.parseAny(cmd.getNewId()));
            pm.update(1);
            hasInteresting = true;
        }
        if (!hasInteresting) {
            return false;
        }
        for (ObjectId have : haves) {
            RevObject o = ow.parseAny(have);
            ow.markUninteresting(o);
            pm.update(1);
            if (!markTrees) continue;
            if ((o = ow.peel(o)) instanceof RevCommit) {
                o = ((RevCommit)o).getTree();
            }
            if (!(o instanceof RevTree)) continue;
            ow.markUninteresting(o);
        }
        return true;
    }

    private void checkCommitTree(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, ProgressMonitor pm) throws IOException {
        RevCommit c;
        ObjectIdSubclassMap<ObjectId> newObjectIds = connectivityCheckInfo.getParser().getNewObjectIds();
        while ((c = ow.next()) != null) {
            pm.update(1);
            if (!connectivityCheckInfo.isCheckObjects() || c.has(RevFlag.UNINTERESTING) || newObjectIds.contains(c)) continue;
            throw new MissingObjectException((ObjectId)c, "commit");
        }
    }

    private void checkObjects(ConnectivityChecker.ConnectivityCheckInfo connectivityCheckInfo, ObjectWalk ow, ProgressMonitor pm) throws IOException {
        RevObject o;
        ObjectIdSubclassMap<ObjectId> newObjectIds = connectivityCheckInfo.getParser().getNewObjectIds();
        while ((o = ow.nextObject()) != null) {
            pm.update(1);
            if (o.has(RevFlag.UNINTERESTING)) continue;
            if (connectivityCheckInfo.isCheckObjects()) {
                if (newObjectIds.contains(o)) continue;
                throw new MissingObjectException((ObjectId)o, o.getType());
            }
            if (!(o instanceof RevBlob) || connectivityCheckInfo.getRepository().getObjectDatabase().has(o)) continue;
            throw new MissingObjectException((ObjectId)o, "blob");
        }
        if (connectivityCheckInfo.isCheckObjects()) {
            for (ObjectId id : connectivityCheckInfo.getParser().getBaseObjectIds()) {
                o = ow.parseAny(id);
                if (o.has(RevFlag.UNINTERESTING)) continue;
                throw new MissingObjectException((ObjectId)o, o.getType());
            }
        }
    }
}

