/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.LockFile;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Constants;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.PackLock;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.FS;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.FileUtils;

public class PackLockImpl
implements PackLock {
    private final File keepFile;

    public PackLockImpl(File packFile, FS fs) {
        File p = packFile.getParentFile();
        String n = packFile.getName();
        this.keepFile = new File(p, n.substring(0, n.length() - 5) + ".keep");
    }

    public boolean lock(String msg) throws IOException {
        LockFile lf;
        if (msg == null) {
            return false;
        }
        if (!((String)msg).endsWith("\n")) {
            msg = (String)msg + "\n";
        }
        if (!(lf = new LockFile(this.keepFile)).lock()) {
            return false;
        }
        lf.write(Constants.encode((String)msg));
        return lf.commit();
    }

    @Override
    public void unlock() throws IOException {
        FileUtils.delete(this.keepFile);
    }
}

