/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal.Util;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.Git;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.ListBranchCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.LogCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.StopWalkException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.TreeRevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.filter.OrRevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.filter.RevFilter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.RemoteConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.URIish;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.StringUtils;
import org.jetbrains.annotations.Nullable;

public interface GitUtils {
    public static final List<String> DEFAULT_ALLOWED_BRANCHES = List.of("master", "main", "HEAD");

    public static String getRelativePath(Path root, Path path) {
        return root.relativize(path).toString().replace(root.getFileSystem().getSeparator(), "/");
    }

    public static String getRelativePath(File root, File file) {
        if (root.equals(file)) {
            return "";
        }
        return GitUtils.getRelativePath(root.toPath(), file.toPath());
    }

    public static int countCommits(Git git, String tag, String tagPrefix, Iterable<String> includePaths, Iterable<String> excludePaths) throws GitAPIException, IOException {
        Map<String, String> tags = GitUtils.getTagToCommitMap(git);
        String commitHash = tags.get(tag);
        if (commitHash == null) {
            return -1;
        }
        return GitUtils.countCommits(git, GitUtils.getCommitToTagMap(git), ObjectId.fromString(commitHash), tagPrefix, includePaths, excludePaths);
    }

    public static int countCommits(Git git, Map<String, String> commitsToTags, ObjectId from, String tagPrefix, Iterable<String> includePaths, Iterable<String> excludePaths) throws GitAPIException, IOException {
        return Util.count(GitUtils.getCommitLogFromTo(git, commitsToTags, from, GitUtils.getHead(git), tagPrefix, includePaths, excludePaths));
    }

    public static RevCommit getHead(Git git) throws IOException {
        return GitUtils.getCommitFromId(git, git.getRepository().resolve("HEAD"));
    }

    public static RevCommit getCommitFromRef(Git git, Ref other) throws IOException {
        return GitUtils.getCommitFromId(git, other.getObjectId());
    }

    public static RevCommit getCommitFromId(Git git, ObjectId other) throws IOException {
        if (other instanceof RevCommit) {
            RevCommit commit = (RevCommit)other;
            return commit;
        }
        try (RevWalk revWalk = new RevWalk(git.getRepository());){
            RevCommit revCommit = revWalk.parseCommit(other);
            return revCommit;
        }
    }

    public static Iterable<RevCommit> getCommitLogFromTo(Git git, Map<String, String> tags, ObjectId from, ObjectId to, String tagPrefix, Iterable<String> includePaths) throws GitAPIException, IOException {
        return GitUtils.getCommitLogFromTo(git, tags, from, to, tagPrefix, includePaths, Collections::emptyIterator);
    }

    /*
     * Unable to fully structure code
     */
    public static Iterable<RevCommit> getCommitLogFromTo(Git git, Map<String, String> commitsToTags, ObjectId from, ObjectId to, String tagPrefix, Iterable<String> includePaths, Iterable<String> excludePaths) throws GitAPIException, IOException {
        start = GitUtils.getCommitFromId(git, from);
        end = GitUtils.getCommitFromId(git, to);
        log = git.log().add(end);
        for (RevCommit parent : start.getParents()) {
            log.not(parent);
        }
        if (Util.forEach(includePaths, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, addPath(java.lang.String ), (Ljava/lang/String;)V)((LogCommand)log))) ** GOTO lbl-1000
        if (Util.forEach(excludePaths, (Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, excludePath(java.lang.String ), (Ljava/lang/String;)V)((LogCommand)log))) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        hasFilters = v0;
        return Util.make((RevWalk)log.call(), (Consumer<RevWalk>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$getCommitLogFromTo$0(boolean java.lang.String java.util.Map net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk ), (Lnet/minecraftforge/gradleutils/shadow/org/eclipse/jgit/revwalk/RevWalk;)V)((boolean)hasFilters, (String)tagPrefix, commitsToTags));
    }

    public static Map<String, String> getCommitToTagMap(Git git) throws GitAPIException, IOException {
        return GitUtils.getCommitToTagMap(git, null);
    }

    public static Map<String, String> getCommitToTagMap(Git git, @Nullable String tagPrefix) throws GitAPIException, IOException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        Iterator iterator = git.tagList().call().iterator();
        while (iterator.hasNext()) {
            Ref tag = (Ref)iterator.next();
            ObjectId tagId = git.getRepository().getRefDatabase().peel(tag).getPeeledObjectId();
            if (tagId == null) {
                tagId = tag.getObjectId();
            }
            if (!StringUtils.isEmptyOrNull(tagPrefix) && !tagId.name().startsWith(tagPrefix)) continue;
            versionMap.put(tagId.name(), tag.getName().replace("refs/tags/", ""));
        }
        return versionMap;
    }

    public static Map<String, String> getTagToCommitMap(Git git) throws GitAPIException, IOException {
        return GitUtils.getTagToCommitMap(git, null);
    }

    public static Map<String, String> getTagToCommitMap(Git git, @Nullable String tagPrefix) throws GitAPIException, IOException {
        HashMap<String, String> versionMap = new HashMap<String, String>();
        Iterator iterator = git.tagList().call().iterator();
        while (iterator.hasNext()) {
            Ref tag = (Ref)iterator.next();
            ObjectId tagId = git.getRepository().getRefDatabase().peel(tag).getPeeledObjectId();
            if (tagId == null) {
                tagId = tag.getObjectId();
            }
            if (!StringUtils.isEmptyOrNull(tagPrefix) && !tagId.name().startsWith(tagPrefix)) continue;
            versionMap.put(tag.getName().replace("refs/tags/", ""), tagId.name());
        }
        return versionMap;
    }

    public static RevCommit getFirstCommitInRepository(Git git) throws GitAPIException {
        Iterator commits = git.log().call().iterator();
        RevCommit commit = null;
        while (commits.hasNext()) {
            commit = (RevCommit)commits.next();
        }
        return commit;
    }

    @Nullable
    public static RevCommit getMergeBaseCommit(Git git) throws GitAPIException, IOException {
        RevCommit headCommit = GitUtils.getHead(git);
        List<Ref> remoteBranches = GitUtils.getAvailableRemoteBranches(git);
        return remoteBranches.stream().filter(branch -> !branch.getObjectId().getName().equals(headCommit.toObjectId().getName())).map(branch -> GitUtils.getMergeBase(git, branch)).filter(revCommit -> revCommit != null && !revCommit.toObjectId().getName().equals(headCommit.toObjectId().getName())).min(Comparator.comparing(revCommit -> Integer.MAX_VALUE - revCommit.getCommitTime())).orElse(null);
    }

    public static List<Ref> getAvailableRemoteBranches(Git git) throws GitAPIException {
        return git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call();
    }

    public static RevCommit getMergeBase(Git git, Ref other) {
        RevWalk walk = new RevWalk(git.getRepository());
        try {
            RevCommit current;
            walk.setRevFilter(RevFilter.MERGE_BASE);
            walk.markStart(GitUtils.getCommitFromRef(git, other));
            walk.markStart(GitUtils.getHead(git));
            RevCommit mergeBase = null;
            while ((current = walk.next()) != null) {
                mergeBase = current;
            }
            RevCommit revCommit = mergeBase;
            walk.close();
            return revCommit;
        }
        catch (Throwable throwable) {
            try {
                try {
                    walk.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (MissingObjectException ignored) {
                return null;
            }
            catch (IOException e) {
                return (RevCommit)Util.sneak(e);
            }
        }
    }

    public static Map<String, String> buildVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String prereleaseTargetVersion = GitUtils.getFirstReleasedVersion(commits, commitHashToVersions);
        ArrayList<RevCommit> reversedCommits = Util.copyList(commits, Collections::reverse);
        String currentVersion = "";
        int offset = 0;
        HashMap<String, String> versionMap = new HashMap<String, String>();
        for (RevCommit commit : reversedCommits) {
            String commitHash = commit.toObjectId().name();
            String version = commitHashToVersions.get(commitHash);
            if (version != null) {
                offset = 0;
                currentVersion = version;
            } else {
                ++offset;
            }
            String releasedVersion = currentVersion + "." + offset;
            if (currentVersion.isEmpty()) {
                releasedVersion = prereleaseTargetVersion + "-pre-%s".formatted(offset);
            }
            versionMap.put(commitHash, releasedVersion);
        }
        return versionMap;
    }

    public static String getFirstReleasedVersion(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String currentVersion = "0.0";
        for (RevCommit commit : commits) {
            String commitHash = commit.toObjectId().name();
            String version = commitHashToVersions.get(commitHash);
            if (version == null) continue;
            currentVersion = version;
        }
        return currentVersion;
    }

    public static Map<String, String> getPrimaryVersionMap(List<RevCommit> commits, Map<String, String> commitHashToVersions) {
        String lastVersion = null;
        ArrayList<String> currentVersionCommitHashes = new ArrayList<String>();
        HashMap<String, String> primaryVersionMap = new HashMap<String, String>();
        for (RevCommit commit : commits) {
            String commitHash = commit.toObjectId().name();
            currentVersionCommitHashes.add(commitHash);
            String version = commitHashToVersions.get(commitHash);
            if (version == null) continue;
            for (String combinedHash : currentVersionCommitHashes) {
                primaryVersionMap.put(combinedHash, version);
                lastVersion = version;
            }
            currentVersionCommitHashes.clear();
        }
        if (commitHashToVersions.isEmpty()) {
            lastVersion = "1.0";
        }
        if (lastVersion != null) {
            for (String combinedHash : currentVersionCommitHashes) {
                primaryVersionMap.put(combinedHash, lastVersion + "-pre");
            }
        }
        return primaryVersionMap;
    }

    public static Map<String, Integer> determinePrefixLengthPerPrimaryVersion(Collection<String> availableVersions, Set<String> availablePrimaryVersions) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        ArrayList<String> sortedVersions = Util.copyList(availablePrimaryVersions, Collections::sort);
        ArrayList<String> workingPrimaryVersions = Util.copyList(sortedVersions, Collections::reverse);
        block0: for (String version : availableVersions) {
            for (String primaryVersion : workingPrimaryVersions) {
                if (!version.startsWith(primaryVersion)) continue;
                int length = version.trim().length();
                if (result.containsKey(primaryVersion) && result.get(primaryVersion) >= length) continue block0;
                result.put(primaryVersion, length);
                continue block0;
            }
        }
        return result;
    }

    public static String processCommitBody(String body) {
        String[] bodyLines = body.split("\n");
        ArrayList<String> resultingLines = new ArrayList<String>();
        for (String bodyLine : bodyLines) {
            if (bodyLine.startsWith("Signed-off-by: ") || bodyLine.trim().isEmpty()) continue;
            resultingLines.add(bodyLine);
        }
        return String.join((CharSequence)"\n", resultingLines).trim();
    }

    public static String buildProjectUrl(String project) {
        return GitUtils.buildProjectUrl("MinecraftForge", project);
    }

    public static String buildProjectUrl(String organization, String project) {
        return GitUtils.buildProjectUrl("github.com", organization, project);
    }

    public static String buildProjectUrl(String domain, String organization, String project) {
        return "https://%s/%s/%s".formatted(domain, organization, project);
    }

    @Nullable
    public static String buildProjectUrl(Git git) {
        Object remotes;
        try {
            remotes = git.remoteList().call();
            if (remotes.isEmpty()) {
                return null;
            }
        }
        catch (GitAPIException e) {
            return null;
        }
        RemoteConfig originRemote = remotes.stream().filter(it -> it.getURIs().stream().anyMatch(uri -> uri.toString().contains("MinecraftForge/"))).findFirst().orElseGet(() -> GitUtils.lambda$buildProjectUrl$9((List)remotes));
        URIish originUrl = Util.findFirst(originRemote.getURIs());
        if (originUrl == null) {
            return null;
        }
        String originUrlString = originUrl.toString();
        if (originUrlString.lastIndexOf(58) > "https://".length()) {
            if (originUrlString.contains("@")) {
                return "https://" + originUrlString.substring(originUrlString.indexOf("@") + 1).replace(".git", "").replace(':', '/');
            }
            return "https://" + originUrlString.replace("ssh://", "").replace(".git", "").replace(':', '/');
        }
        if (originUrlString.startsWith("http")) {
            return originUrlString.replace(".git", "");
        }
        return originUrlString;
    }

    private static /* synthetic */ RemoteConfig lambda$buildProjectUrl$9(List remotes) {
        return remotes.stream().filter(remote -> "origin".equals(remote.getName())).findFirst().orElseGet(() -> (RemoteConfig)remotes.get(0));
    }

    private static /* synthetic */ void lambda$getCommitLogFromTo$0(boolean hasFilters, final String tagPrefix, final Map commitsToTags, RevWalk walk) {
        if (!hasFilters || StringUtils.isEmptyOrNull(tagPrefix) || commitsToTags == null || commitsToTags.isEmpty()) {
            return;
        }
        walk.setRevFilter(OrRevFilter.create(new TreeRevFilter(walk, walk.getTreeFilter()), new RevFilter(){

            @Override
            public boolean include(RevWalk walker, RevCommit cmit) throws StopWalkException {
                return commitsToTags.getOrDefault(ObjectId.toString(cmit), "").startsWith(tagPrefix);
            }

            @Override
            public RevFilter clone() {
                throw new UnsupportedOperationException();
            }
        }));
        walk.setTreeFilter(null);
    }
}

