/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.api;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal.GitVersionConfigImpl;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface GitVersionConfig
extends Function<String, Project> {
    public static final GitVersionConfig EMPTY = GitVersionConfigImpl.EMPTY;

    @Nullable
    public Project getProject(@Nullable String var1);

    private Project getRootProject() {
        return this.getProject("");
    }

    default public Collection<Project> getAllProjects() {
        return Collections.singleton(this.getRootProject());
    }

    default public void validate(@UnknownNullability File root) throws IllegalArgumentException {
    }

    default public List<? extends RuntimeException> errors() {
        return Collections.emptyList();
    }

    public static GitVersionConfig parse(@UnknownNullability File config) {
        try {
            return GitVersionConfigImpl.parse(config);
        }
        catch (IOException e) {
            return EMPTY;
        }
    }

    @Override
    @Nullable
    default public Project apply(@Nullable String path) {
        return this.getProject(path);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Project {
        public String getPath();

        public String getTagPrefix();

        public String[] getFilters();
    }
}

