/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib;

import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;

public class SymbolicRef
implements Ref {
    private final String name;
    private final Ref target;
    private final long updateIndex;

    public SymbolicRef(@NonNull String refName, @NonNull Ref target) {
        this.name = refName;
        this.target = target;
        this.updateIndex = -1L;
    }

    public SymbolicRef(@NonNull String refName, @NonNull Ref target, long updateIndex) {
        this.name = refName;
        this.target = target;
        this.updateIndex = updateIndex;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return true;
    }

    @Override
    @NonNull
    public Ref getLeaf() {
        Ref dst = this.getTarget();
        while (dst.isSymbolic()) {
            dst = dst.getTarget();
        }
        return dst;
    }

    @Override
    @NonNull
    public Ref getTarget() {
        return this.target;
    }

    @Override
    @Nullable
    public ObjectId getObjectId() {
        return this.getLeaf().getObjectId();
    }

    @Override
    @NonNull
    public Ref.Storage getStorage() {
        return Ref.Storage.LOOSE;
    }

    @Override
    @Nullable
    public ObjectId getPeeledObjectId() {
        return this.getLeaf().getPeeledObjectId();
    }

    @Override
    public boolean isPeeled() {
        return this.getLeaf().isPeeled();
    }

    @Override
    public long getUpdateIndex() {
        if (this.updateIndex == -1L) {
            throw new UnsupportedOperationException();
        }
        return this.updateIndex;
    }

    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("SymbolicRef[");
        Ref cur = this;
        while (cur.isSymbolic()) {
            r.append(cur.getName());
            r.append(" -> ");
            cur = cur.getTarget();
        }
        r.append(cur.getName());
        r.append('=');
        r.append(ObjectId.toString(cur.getObjectId()));
        r.append("(");
        r.append(this.updateIndex);
        r.append(")]");
        return r.toString();
    }
}

