/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.util;

import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.util.CleanupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ShutdownHook {
    INSTANCE;

    private static final Logger LOG;
    private final Set<Listener> listeners = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean();

    static {
        LOG = LoggerFactory.getLogger(ShutdownHook.class);
    }

    private ShutdownHook() {
        CleanupService.getInstance().register(this::cleanup);
    }

    private void cleanup() {
        if (!this.shutdownInProgress.getAndSet(true)) {
            ExecutorService runner = Executors.newWorkStealingPool();
            try {
                try {
                    runner.submit(() -> {
                        this.doCleanup();
                        return null;
                    }).get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            finally {
                runner.shutdownNow();
            }
        }
    }

    private void doCleanup() {
        this.listeners.parallelStream().forEach(this::notify);
    }

    private void notify(Listener l) {
        LOG.debug(JGitText.get().shutdownCleanup, (Object)l);
        try {
            l.onShutdown();
        }
        catch (RuntimeException e) {
            LOG.error(MessageFormat.format(JGitText.get().shutdownCleanupListenerFailed, l), (Throwable)e);
        }
    }

    public boolean register(Listener l) {
        if (this.shutdownInProgress.get()) {
            return this.listeners.contains(l);
        }
        LOG.debug("register {} with shutdown hook", (Object)l);
        this.listeners.add(l);
        return true;
    }

    public boolean unregister(Listener l) {
        if (this.shutdownInProgress.get()) {
            return !this.listeners.contains(l);
        }
        LOG.debug("unregister {} from shutdown hook", (Object)l);
        this.listeners.remove(l);
        return true;
    }

    public boolean isShutdownInProgress() {
        return this.shutdownInProgress.get();
    }

    public static interface Listener {
        public void onShutdown();
    }
}

