/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.transport.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.PackProtocolException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;

public class FirstWant {
    private final String line;
    private final Set<String> capabilities;
    @Nullable
    private final String agent;
    @Nullable
    private final String clientSID;
    private static final String AGENT_PREFIX = "agent=";
    private static final String SESSION_ID_PREFIX = "session-id=";

    public static FirstWant fromLine(String line) throws PackProtocolException {
        Set<String> capabilities;
        String wantLine;
        String agent = null;
        String clientSID = null;
        if (line.length() > 45) {
            String opt = line.substring(45);
            if (!opt.startsWith(" ")) {
                throw new PackProtocolException(JGitText.get().wantNoSpaceWithCapabilities);
            }
            opt = opt.substring(1);
            HashSet<String> opts = new HashSet<String>();
            String[] stringArray = opt.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String clientCapability = stringArray[n2];
                if (clientCapability.startsWith(AGENT_PREFIX)) {
                    agent = clientCapability.substring(AGENT_PREFIX.length());
                } else if (clientCapability.startsWith(SESSION_ID_PREFIX)) {
                    clientSID = clientCapability.substring(SESSION_ID_PREFIX.length());
                } else {
                    opts.add(clientCapability);
                }
                ++n2;
            }
            wantLine = line.substring(0, 45);
            capabilities = Collections.unmodifiableSet(opts);
        } else {
            wantLine = line;
            capabilities = Collections.emptySet();
        }
        return new FirstWant(wantLine, capabilities, agent, clientSID);
    }

    private FirstWant(String line, Set<String> capabilities, @Nullable String agent, @Nullable String clientSID) {
        this.line = line;
        this.capabilities = capabilities;
        this.agent = agent;
        this.clientSID = clientSID;
    }

    public String getLine() {
        return this.line;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public String getAgent() {
        return this.agent;
    }

    @Nullable
    public String getClientSID() {
        return this.clientSID;
    }
}

