/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.midx;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.AnyObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.MutableObjectId;

class PackIndexMerger {
    private static final int LIMIT_31_BITS = Integer.MAX_VALUE;
    private static final long LIMIT_32_BITS = 0xFFFFFFFFL;
    private final List<String> packNames;
    private final List<PackIndex> indexes;
    private final boolean needsLargeOffsetsChunk;
    private final int offsetsOver31BitsCount;
    private final int uniqueObjectCount;

    PackIndexMerger(Map<String, PackIndex> packs) {
        this.packNames = packs.keySet().stream().sorted().collect(Collectors.toUnmodifiableList());
        this.indexes = this.packNames.stream().map(packs::get).collect(Collectors.toUnmodifiableList());
        int objectCount = 0;
        boolean hasLargeOffsets = false;
        int over31bits = 0;
        MutableObjectId lastSeen = new MutableObjectId();
        MultiIndexIterator it = new MultiIndexIterator(this.indexes);
        while (it.hasNext()) {
            MidxMutableEntry entry = it.next();
            if (lastSeen.equals(entry.oid)) continue;
            if (entry.offset > 0xFFFFFFFFL) {
                hasLargeOffsets = true;
            }
            if (entry.offset > Integer.MAX_VALUE) {
                ++over31bits;
            }
            lastSeen.fromObjectId(entry.oid);
            ++objectCount;
        }
        this.uniqueObjectCount = objectCount;
        this.offsetsOver31BitsCount = over31bits;
        this.needsLargeOffsetsChunk = hasLargeOffsets;
    }

    int getUniqueObjectCount() {
        return this.uniqueObjectCount;
    }

    boolean needsLargeOffsetsChunk() {
        return this.needsLargeOffsetsChunk;
    }

    int getOffsetsOver31BitsCount() {
        return this.offsetsOver31BitsCount;
    }

    List<String> getPackNames() {
        return this.packNames;
    }

    int getPackCount() {
        return this.packNames.size();
    }

    Iterator<MidxMutableEntry> bySha1Iterator() {
        return new DedupMultiIndexIterator(new MultiIndexIterator(this.indexes), this.getUniqueObjectCount());
    }

    Iterator<MidxMutableEntry> rawIterator() {
        return new MultiIndexIterator(this.indexes);
    }

    private static class DedupMultiIndexIterator
    implements Iterator<MidxMutableEntry> {
        private final MultiIndexIterator src;
        private int remaining;
        private final MutableObjectId lastOid = new MutableObjectId();

        DedupMultiIndexIterator(MultiIndexIterator src, int totalCount) {
            this.src = src;
            this.remaining = totalCount;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public MidxMutableEntry next() {
            MidxMutableEntry next = this.src.next();
            while (next != null && this.lastOid.equals(next.oid)) {
                next = this.src.next();
            }
            if (next == null) {
                throw new NoSuchElementException();
            }
            this.lastOid.fromObjectId(next.oid);
            --this.remaining;
            return next;
        }
    }

    static class MidxMutableEntry {
        private final MutableObjectId oid = new MutableObjectId();
        private int packId;
        private long offset;

        MidxMutableEntry() {
        }

        public AnyObjectId getObjectId() {
            return this.oid;
        }

        public int getPackId() {
            return this.packId;
        }

        public long getOffset() {
            return this.offset;
        }

        private void fill(int packId, PackIndex.MutableEntry other) {
            other.copyOidTo(this.oid);
            this.packId = packId;
            this.offset = other.getOffset();
        }
    }

    private static final class MultiIndexIterator
    implements Iterator<MidxMutableEntry> {
        private final List<PackIndexPeekIterator> indexIterators;
        private final MidxMutableEntry mutableEntry = new MidxMutableEntry();

        MultiIndexIterator(List<PackIndex> indexes) {
            this.indexIterators = new ArrayList<PackIndexPeekIterator>(indexes.size());
            int i = 0;
            while (i < indexes.size()) {
                PackIndexPeekIterator it = new PackIndexPeekIterator(i, indexes.get(i));
                if (it.next() != null) {
                    this.indexIterators.add(it);
                }
                ++i;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.indexIterators.isEmpty();
        }

        @Override
        public MidxMutableEntry next() {
            PackIndexPeekIterator winner = null;
            int index = 0;
            while (index < this.indexIterators.size()) {
                PackIndexPeekIterator current = this.indexIterators.get(index);
                if (winner == null || current.peek().compareBySha1To(winner.peek()) < 0) {
                    winner = current;
                }
                ++index;
            }
            if (winner == null) {
                throw new NoSuchElementException();
            }
            this.mutableEntry.fill(winner.getPackId(), winner.peek());
            if (winner.next() == null) {
                this.indexIterators.remove(winner);
            }
            return this.mutableEntry;
        }
    }

    static class PackIndexPeekIterator {
        private final Iterator<PackIndex.MutableEntry> it;
        private final int packId;
        PackIndex.MutableEntry current;

        PackIndexPeekIterator(int packId, PackIndex index) {
            this.it = index.iterator();
            this.packId = packId;
        }

        PackIndex.MutableEntry next() {
            this.current = this.it.hasNext() ? this.it.next() : null;
            return this.current;
        }

        PackIndex.MutableEntry peek() {
            return this.current;
        }

        int getPackId() {
            return this.packId;
        }
    }
}

