/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.BitmapIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.ReachabilityChecker;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevFlag;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevSort;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.filter.RevFilter;

public class BitmappedReachabilityChecker
implements ReachabilityChecker {
    private final RevWalk walk;

    public BitmappedReachabilityChecker(RevWalk walk) throws IOException {
        this.walk = walk;
        if (walk.getObjectReader().getBitmapIndex() == null) {
            throw new AssertionError((Object)"Trying to use bitmapped reachability check on a repository without bitmaps");
        }
    }

    @Override
    public Optional<RevCommit> areAllReachable(Collection<RevCommit> targets, Stream<RevCommit> starters) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ArrayList<RevCommit> remainingTargets = new ArrayList<RevCommit>(targets);
        this.walk.reset();
        this.walk.sort(RevSort.TOPO);
        BitmapIndex repoBitmaps = this.walk.getObjectReader().getBitmapIndex();
        ReachedFilter reachedFilter = new ReachedFilter(repoBitmaps);
        this.walk.setRevFilter(reachedFilter);
        Iterator startersIter = starters.iterator();
        while (startersIter.hasNext()) {
            this.walk.markStart((RevCommit)startersIter.next());
            while (this.walk.next() != null) {
                remainingTargets.removeIf(reachedFilter::isReachable);
                if (!remainingTargets.isEmpty()) continue;
                return Optional.empty();
            }
            this.walk.reset();
        }
        return Optional.of((RevCommit)remainingTargets.get(0));
    }

    private static class ReachedFilter
    extends RevFilter {
        private final BitmapIndex repoBitmaps;
        private final BitmapIndex.BitmapBuilder reached;

        public ReachedFilter(BitmapIndex repoBitmaps) {
            this.repoBitmaps = repoBitmaps;
            this.reached = repoBitmaps.newBitmapBuilder();
        }

        @Override
        public final boolean include(RevWalk walker, RevCommit cmit) {
            if (this.reached.contains(cmit)) {
                ReachedFilter.dontFollow(cmit);
                return false;
            }
            BitmapIndex.Bitmap commitBitmap = this.repoBitmaps.getBitmap(cmit);
            if (commitBitmap != null) {
                this.reached.or(commitBitmap);
                ReachedFilter.dontFollow(cmit);
                return true;
            }
            this.reached.addObject(cmit, 1);
            return true;
        }

        private static final void dontFollow(RevCommit cmit) {
            RevCommit[] revCommitArray = cmit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit p = revCommitArray[n2];
                p.add(RevFlag.SEEN);
                ++n2;
            }
        }

        @Override
        public final RevFilter clone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean requiresCommitBody() {
            return false;
        }

        boolean isReachable(RevCommit commit) {
            return this.reached.contains(commit);
        }
    }
}

