/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors;

import java.io.IOException;
import java.text.MessageFormat;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;

public class CheckoutConflictException
extends IOException {
    private static final long serialVersionUID = 1L;
    private final String[] conflicting;

    public CheckoutConflictException(String file) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFile, file));
        this.conflicting = new String[]{file};
    }

    public CheckoutConflictException(String[] files) {
        super(MessageFormat.format(JGitText.get().checkoutConflictWithFiles, CheckoutConflictException.buildList(files)));
        this.conflicting = files;
    }

    public String[] getConflictingFiles() {
        return this.conflicting;
    }

    private static String buildList(String[] files) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            builder.append("\n");
            builder.append(f);
            ++n2;
        }
        return builder.toString();
    }
}

