/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.VerificationResult;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.ServiceUnavailableException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.WrongObjectTypeException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.SignatureVerifier;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.SignatureVerifiers;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevObject;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;

public class VerifySignatureCommand
extends GitCommand<Map<String, VerificationResult>> {
    private final Set<String> namesToCheck = new HashSet<String>();
    private VerifyMode mode = VerifyMode.ANY;
    private GpgConfig config;

    public VerifySignatureCommand(Repository repo) {
        super(repo);
    }

    public VerifySignatureCommand addName(String name) {
        this.checkCallable();
        this.namesToCheck.add(name);
        return this;
    }

    public VerifySignatureCommand addNames(String ... names) {
        this.checkCallable();
        this.namesToCheck.addAll(Arrays.asList(names));
        return this;
    }

    public VerifySignatureCommand addNames(Collection<String> names) {
        this.checkCallable();
        this.namesToCheck.addAll(names);
        return this;
    }

    public VerifySignatureCommand setMode(@NonNull VerifyMode mode) {
        this.checkCallable();
        this.mode = mode;
        return this;
    }

    public VerifySignatureCommand setGpgConfig(GpgConfig config) {
        this.checkCallable();
        this.config = config;
        return this;
    }

    @Override
    @NonNull
    public Map<String, VerificationResult> call() throws ServiceUnavailableException, WrongObjectTypeException {
        this.checkCallable();
        this.setCallable(false);
        HashMap<String, VerificationResult> result = new HashMap<String, VerificationResult>();
        if (this.config == null) {
            this.config = new GpgConfig(this.repo.getConfig());
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RevWalk walk = new RevWalk(this.repo);){
                for (String toCheck : this.namesToCheck) {
                    RevObject object;
                    ObjectId id = this.repo.resolve(toCheck);
                    if (id == null || ObjectId.zeroId().equals(id)) continue;
                    try {
                        object = walk.parseAny(id);
                    }
                    catch (MissingObjectException e) {
                        continue;
                    }
                    VerificationResult verification = this.verifyOne(object);
                    if (verification == null) continue;
                    result.put(toCheck, verification);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().signatureVerificationError, e);
        }
        return result;
    }

    private VerificationResult verifyOne(RevObject object) throws WrongObjectTypeException, IOException {
        int type = object.getType();
        if (VerifyMode.TAGS.equals((Object)this.mode) && type != 4) {
            throw new WrongObjectTypeException(object, 4);
        }
        if (VerifyMode.COMMITS.equals((Object)this.mode) && type != 1) {
            throw new WrongObjectTypeException(object, 1);
        }
        if (type == 1 || type == 4) {
            SignatureVerifier.SignatureVerification verification;
            block6: {
                try {
                    verification = SignatureVerifiers.verify(this.repo, this.config, object);
                    if (verification != null) break block6;
                    return null;
                }
                catch (JGitInternalException e) {
                    return new Result(object, null, e);
                }
            }
            return new Result(object, verification, null);
        }
        return null;
    }

    private static class Result
    implements VerificationResult {
        private final Throwable throwable;
        private final SignatureVerifier.SignatureVerification verification;
        private final RevObject object;

        public Result(RevObject object, SignatureVerifier.SignatureVerification verification, Throwable throwable) {
            this.object = object;
            this.verification = verification;
            this.throwable = throwable;
        }

        @Override
        public Throwable getException() {
            return this.throwable;
        }

        @Override
        public SignatureVerifier.SignatureVerification getVerification() {
            return this.verification;
        }

        @Override
        public RevObject getObject() {
            return this.object;
        }
    }

    public static enum VerifyMode {
        ANY,
        COMMITS,
        TAGS;

    }
}

