/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.ApplyResult;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.PatchApplyException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.PatchFormatException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.patch.Patch;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.patch.PatchApplier;

public class ApplyCommand
extends GitCommand<ApplyResult> {
    private InputStream in;

    ApplyCommand(Repository repo) {
        super(repo);
        if (repo == null) {
            throw new NullPointerException(JGitText.get().repositoryIsRequired);
        }
    }

    public ApplyCommand setPatch(InputStream in) {
        this.checkCallable();
        this.in = in;
        return this;
    }

    @Override
    public ApplyResult call() throws GitAPIException {
        this.checkCallable();
        this.setCallable(false);
        Patch patch = new Patch();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream inStream = this.in;){
                patch.parse(inStream);
                if (!patch.getErrors().isEmpty()) {
                    throw new PatchFormatException(patch.getErrors());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage()), e);
        }
        ApplyResult r = new ApplyResult();
        try {
            PatchApplier patchApplier = new PatchApplier(this.repo);
            PatchApplier.Result applyResult = patchApplier.applyPatch(patch);
            if (!applyResult.getErrors().isEmpty()) {
                throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, applyResult.getErrors()));
            }
            for (String p : applyResult.getPaths()) {
                r.addUpdatedFile(new File(this.repo.getWorkTree(), p));
            }
        }
        catch (IOException e) {
            throw new PatchApplyException(MessageFormat.format(JGitText.get().patchApplyException, e.getMessage(), e));
        }
        return r;
    }
}

