/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32;

import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.IntIterator;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.IteratingRLW32;

public class IntIteratorOverIteratingRLW32
implements IntIterator {
    final IteratingRLW32 parent;
    private int position;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    public IntIteratorOverIteratingRLW32(IteratingRLW32 p) {
        this.parent = p;
        this.position = 0;
        this.setupForCurrentRunningLengthWord();
        this.hasNext = this.moveToNext();
    }

    private boolean moveToNext() {
        while (!this.runningHasNext() && !this.literalHasNext()) {
            if (this.parent.next()) {
                this.setupForCurrentRunningLengthWord();
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public final int next() {
        int answer;
        if (this.runningHasNext()) {
            answer = this.position++;
        } else {
            int t2 = this.word & -this.word;
            answer = this.literalPosition + Integer.bitCount(t2 - 1);
            this.word ^= t2;
        }
        this.hasNext = this.moveToNext();
        return answer;
    }

    private void setupForCurrentRunningLengthWord() {
        this.runningLength = 32 * this.parent.getRunningLength() + this.position;
        if (!this.parent.getRunningBit()) {
            this.position = this.runningLength;
        }
        this.wordPosition = 0;
        this.wordLength = this.parent.getNumberOfLiteralWords();
    }

    private boolean runningHasNext() {
        return this.position < this.runningLength;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordPosition < this.wordLength) {
            this.word = this.parent.getLiteralWordAt(this.wordPosition++);
            this.literalPosition = this.position;
            this.position += 32;
        }
        return this.word != 0;
    }
}

