/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32;

import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah.IntIterator;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.Buffer32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.ReverseEWAHIterator32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.RunningLengthWord32;

final class ReverseIntIterator32
implements IntIterator {
    private final ReverseEWAHIterator32 ewahIter;
    private final int sizeInBits;
    private final Buffer32 buffer;
    private int position;
    private boolean runningBit;
    private int runningLength;
    private int word;
    private int wordPosition;
    private int wordLength;
    private int literalPosition;
    private boolean hasNext;

    ReverseIntIterator32(ReverseEWAHIterator32 ewahIter, int sizeInBits) {
        this.ewahIter = ewahIter;
        this.sizeInBits = sizeInBits;
        this.buffer = ewahIter.buffer();
        this.runningLength = sizeInBits - 1;
        this.hasNext = this.moveToPreviousRLW();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public int next() {
        int answer;
        if (this.literalHasNext()) {
            int t2 = this.word & -this.word;
            answer = this.literalPosition - Integer.bitCount(t2 - 1);
            this.word ^= t2;
        } else {
            answer = this.position--;
        }
        this.hasNext = this.moveToPreviousRLW();
        return answer;
    }

    private boolean moveToPreviousRLW() {
        while (!this.literalHasNext() && !this.runningHasNext()) {
            if (!this.ewahIter.hasPrevious()) {
                return false;
            }
            this.setRLW(this.ewahIter.previous());
        }
        return true;
    }

    private void setRLW(RunningLengthWord32 rlw) {
        int usedBitsInLast;
        this.wordLength = rlw.getNumberOfLiteralWords();
        this.wordPosition = this.ewahIter.position();
        this.position = this.runningLength;
        this.runningLength -= 32 * (rlw.getRunningLength() + this.wordLength);
        if (this.position == this.sizeInBits - 1 && (usedBitsInLast = this.sizeInBits % 32) > 0) {
            this.runningLength += 32 - usedBitsInLast;
            if (this.wordLength > 0) {
                this.word = Integer.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
                this.word >>>= 32 - usedBitsInLast;
                this.literalPosition = this.position;
                this.position -= usedBitsInLast;
            }
        }
        this.runningBit = rlw.getRunningBit();
    }

    private boolean runningHasNext() {
        return this.runningBit && this.runningLength < this.position;
    }

    private boolean literalHasNext() {
        while (this.word == 0 && this.wordLength > 0) {
            this.word = Integer.reverse(this.buffer.getWord(this.wordPosition + this.wordLength--));
            this.literalPosition = this.position;
            this.position -= 32;
        }
        return this.word != 0;
    }
}

