/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.changelog;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.api.GitVersion;
import net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.api.GitVersionException;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ResourceGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.vmplugin.v8.IndyInterface;
import org.gradle.api.DefaultTask;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class GenerateChangelog
extends DefaultTask
implements GroovyObject {
    static final String NAME = "createChangelog";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public GenerateChangelog() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = "Generates a changelog for the project based on the Git history using Git Version.";
        this.setDescription(string);
        this.getOutputFile().convention(this.getLayout().getBuildDirectory().file("changelog/changelog.txt"));
        this.getGitDirectory().convention(this.getObjects().directoryProperty().fileProvider(this.getProviders().provider((Callable)((Object)new _closure1((Object)this, (Object)this)))).dir(".git"));
        this.getProjectPath().convention(this.getProviders().provider((Callable)((Object)new _closure2((Object)this, (Object)this))));
        this.getBuildMarkdown().convention((Object)false);
    }

    @Inject
    public abstract ObjectFactory getObjects();

    @Inject
    public abstract ProjectLayout getLayout();

    @Inject
    public abstract ProviderFactory getProviders();

    @Inject
    public abstract BuildFeatures getBuildFeatures();

    @OutputFile
    public abstract RegularFileProperty getOutputFile();

    @InputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    public abstract DirectoryProperty getGitDirectory();

    @Input
    public abstract Property<String> getProjectPath();

    @Input
    @Optional
    public abstract Property<String> getStart();

    @Input
    @Optional
    public abstract Property<String> getProjectUrl();

    @Input
    public abstract Property<Boolean> getBuildMarkdown();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @TaskAction
    public void exec() throws IOException {
        Throwable __$$primaryExc0;
        GitVersion version;
        Object object = this.getBuildFeatures().getConfigurationCache().getActive().getOrElse((Object)false);
        if (object == null ? false : (Boolean)object) {
            GitVersion.disableSystemConfig();
        }
        CallSite gitDir = IndyInterface.bootstrap("cast", "()", 0, this.getGitDirectory().getAsFile().get());
        try {
            version = GitVersion.builder().gitDir((File)((Object)gitDir)).project(new File(((File)((Object)gitDir)).getAbsoluteFile().getParentFile(), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getProjectPath().get())))).build();
            __$$primaryExc0 = null;
            try {
                try {
                    Object object2 = this.getBuildMarkdown().get();
                    String changelog = version.generateChangelog((String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getStart().getOrNull())), (String)((Object)IndyInterface.bootstrap("cast", "()", 0, this.getProjectUrl().getOrNull())), !(object2 == null ? false : (Boolean)object2));
                    CallSite file = IndyInterface.bootstrap("cast", "()", 0, this.getOutputFile().getAsFile().get());
                    if (!((File)((Object)file)).getParentFile().exists()) {
                        ((File)((Object)file)).getParentFile().mkdirs();
                    }
                    ResourceGroovyMethods.setText((File)((Object)file), (String)changelog, (String)"UTF8");
                }
                catch (Throwable __$$t0) {
                    __$$primaryExc0 = __$$t0;
                    throw __$$t0;
                }
            }
            catch (Throwable throwable) {
                Object v4;
                if (__$$primaryExc0 != null) {
                    try {
                        Object v2;
                        GitVersion gitVersion2 = version;
                        if (gitVersion2 != null) {
                            gitVersion2.close();
                            v2 = null;
                            throw throwable;
                        }
                        v2 = null;
                        throw throwable;
                    }
                    catch (Throwable __$$suppressedExc0) {
                        Object v3;
                        Throwable throwable2 = __$$primaryExc0;
                        if (throwable2 != null) {
                            throwable2.addSuppressed(__$$suppressedExc0);
                            v3 = null;
                            throw throwable;
                        }
                        v3 = null;
                        throw throwable;
                    }
                }
                GitVersion gitVersion3 = version;
                if (gitVersion3 != null) {
                    gitVersion3.close();
                    v4 = null;
                    throw throwable;
                }
                v4 = null;
                throw throwable;
            }
        }
        catch (GitVersionException e) {
            this.getLogger().error("ERROR: Failed to generate the changelog for this project, likely due to a misconfiguration. GitVersion has caught the exception, the details of which are attached to this error. Check that the correct tags are being used, or updating the tag prefix accordingly.");
            throw (Throwable)e;
        }
        catch (IOException e) {
            this.getLogger().error("ERROR: Changelog was generated successfully, but could not be written to the disk. Ensure that you have write permissions to the output directory.");
            throw (Throwable)new RuntimeException(e);
        }
        if (__$$primaryExc0 != null) {
            try {
                GitVersion gitVersion = version;
                if (gitVersion == null) return;
                gitVersion.close();
                return;
            }
            catch (Throwable __$$suppressedExc0) {
                Throwable throwable = __$$primaryExc0;
                if (throwable == null) return;
                throwable.addSuppressed(__$$suppressedExc0);
                return;
            }
        }
        GitVersion gitVersion = version;
        if (gitVersion == null) return;
        gitVersion.close();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GenerateChangelog.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public final class _closure1
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure1(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public File doCall(Object it) {
            return GitVersion.findGitRoot(((GenerateChangelog)((Object)this.getThisObject())).getLayout().getProjectDirectory().getAsFile());
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public File doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure1.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }

    public final class _closure2
    extends Closure
    implements GeneratedClosure {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;

        public _closure2(Object _outerInstance, Object _thisObject) {
            super(_outerInstance, _thisObject);
        }

        public String doCall(Object it) {
            return GitVersion.findRelativePath(((GenerateChangelog)((Object)this.getThisObject())).getLayout().getProjectDirectory().getAsFile());
        }

        @Generated
        public Object call(Object args) {
            return this.doCall(args);
        }

        @Generated
        public Object call() {
            return this.doCall(null);
        }

        @Generated
        public String doCall() {
            return this.doCall(null);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != _closure2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }
    }
}

