/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk;

import java.io.IOException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.AnyObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Constants;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectIdOwnerMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevFlag;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevFlagSet;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;

public abstract class RevObject
extends ObjectIdOwnerMap.Entry {
    static final int PARSED = 1;
    int flags;

    RevObject(AnyObjectId name) {
        super(name);
    }

    abstract void parseHeaders(RevWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    abstract void parseBody(RevWalk var1) throws MissingObjectException, IncorrectObjectTypeException, IOException;

    public abstract int getType();

    public final ObjectId getId() {
        return this;
    }

    public final boolean has(RevFlag flag) {
        return (this.flags & flag.mask) != 0;
    }

    public final boolean hasAny(RevFlagSet set) {
        return (this.flags & set.mask) != 0;
    }

    public final boolean hasAll(RevFlagSet set) {
        return (this.flags & set.mask) == set.mask;
    }

    public final void add(RevFlag flag) {
        this.flags |= flag.mask;
    }

    public final void add(RevFlagSet set) {
        this.flags |= set.mask;
    }

    public final void remove(RevFlag flag) {
        this.flags &= ~flag.mask;
    }

    public final void remove(RevFlagSet set) {
        this.flags &= ~set.mask;
    }

    @Override
    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append(Constants.typeString(this.getType()));
        s2.append(' ');
        s2.append(this.name());
        s2.append(' ');
        this.appendCoreFlags(s2);
        return s2.toString();
    }

    protected void appendCoreFlags(StringBuilder s2) {
        s2.append((this.flags & 0x20) != 0 ? (char)'o' : '-');
        s2.append((this.flags & 0x40) != 0 ? (char)'q' : '-');
        s2.append((this.flags & 0x10) != 0 ? (char)'t' : '-');
        s2.append((this.flags & 8) != 0 ? (char)'r' : '-');
        s2.append((this.flags & 4) != 0 ? (char)'u' : '-');
        s2.append((this.flags & 2) != 0 ? (char)'s' : '-');
        s2.append((this.flags & 1) != 0 ? (char)'p' : '-');
    }
}

