/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib;

import java.text.MessageFormat;
import java.util.EnumMap;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.NonNull;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Signer;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.SignerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Signers {
    private static final Logger LOG = LoggerFactory.getLogger(Signers.class);
    private static final Map<GpgConfig.GpgFormat, SignerFactory> SIGNER_FACTORIES = Signers.loadSigners();
    private static final Map<GpgConfig.GpgFormat, Signer> SIGNERS = new ConcurrentHashMap<GpgConfig.GpgFormat, Signer>();

    private static Map<GpgConfig.GpgFormat, SignerFactory> loadSigners() {
        EnumMap<GpgConfig.GpgFormat, SignerFactory> result = new EnumMap<GpgConfig.GpgFormat, SignerFactory>(GpgConfig.GpgFormat.class);
        try {
            for (SignerFactory factory : ServiceLoader.load(SignerFactory.class)) {
                GpgConfig.GpgFormat format = factory.getType();
                SignerFactory existing = (SignerFactory)result.get(format);
                if (existing != null) {
                    LOG.warn("{}", (Object)MessageFormat.format(JGitText.get().signatureServiceConflict, "SignerFactory", format, existing.getClass().getCanonicalName(), factory.getClass().getCanonicalName()));
                    continue;
                }
                result.put(format, factory);
            }
        }
        catch (ServiceConfigurationError e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private Signers() {
    }

    public static Signer get(@NonNull GpgConfig.GpgFormat format) {
        return SIGNERS.computeIfAbsent(format, f -> {
            SignerFactory factory = SIGNER_FACTORIES.get(format);
            if (factory == null) {
                return null;
            }
            return factory.create();
        });
    }

    public static void set(@NonNull GpgConfig.GpgFormat format, Signer signer) {
        if (signer == null) {
            SIGNERS.remove(format);
        } else {
            SIGNERS.put(format, signer);
        }
    }
}

