/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.LogCursor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.RefCursor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.Reftable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.reftable.ReftableReader;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.AnyObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogEntry;

public class MergedReftable
extends Reftable {
    private final ReftableReader[] tables;

    public MergedReftable(List<ReftableReader> tableStack) {
        ReftableReader[] reftableReaderArray = this.tables = tableStack.toArray(new ReftableReader[0]);
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            ReftableReader t2 = reftableReaderArray[n2];
            t2.setIncludeDeletes(true);
            ++n2;
        }
    }

    @Override
    public long maxUpdateIndex() throws IOException {
        if (this.tables.length == 0) {
            return 0L;
        }
        long maxUpdateIndex = this.tables[this.tables.length - 1].maxUpdateIndex();
        int i = this.tables.length - 2;
        while (i >= 0) {
            if (maxUpdateIndex < this.tables[i].maxUpdateIndex()) {
                maxUpdateIndex = this.tables[i].maxUpdateIndex();
            }
            --i;
        }
        return maxUpdateIndex;
    }

    @Override
    public long minUpdateIndex() throws IOException {
        if (this.tables.length == 0) {
            return 0L;
        }
        long minUpdateIndex = this.tables[0].minUpdateIndex();
        int i = 1;
        while (i < this.tables.length) {
            if (this.tables[i].minUpdateIndex() < minUpdateIndex) {
                minUpdateIndex = this.tables[i].minUpdateIndex();
            }
            ++i;
        }
        return minUpdateIndex;
    }

    @Override
    public boolean hasObjectMap() throws IOException {
        boolean has = true;
        int i = 0;
        while (has && i < this.tables.length) {
            has = has && this.tables[i].hasObjectMap();
            ++i;
        }
        return has;
    }

    @Override
    public RefCursor allRefs() throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i].allRefs(), i));
            ++i;
        }
        return m4;
    }

    @Override
    public RefCursor seekRef(String name) throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i].seekRef(name), i));
            ++i;
        }
        return m4;
    }

    @Override
    public RefCursor seekRefsWithPrefix(String prefix) throws IOException {
        MergedRefCursor m4 = new MergedRefCursor();
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i].seekRefsWithPrefix(prefix), i));
            ++i;
        }
        return m4;
    }

    @Override
    public RefCursor byObjectId(AnyObjectId name) throws IOException {
        FilteringMergedRefCursor m4 = new FilteringMergedRefCursor(name);
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new RefQueueEntry(this.tables[i].byObjectId(name), i));
            ++i;
        }
        return m4;
    }

    @Override
    public LogCursor allLogs() throws IOException {
        MergedLogCursor m4 = new MergedLogCursor();
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new LogQueueEntry(this.tables[i].allLogs(), i));
            ++i;
        }
        return m4;
    }

    @Override
    public LogCursor seekLog(String refName, long updateIdx) throws IOException {
        MergedLogCursor m4 = new MergedLogCursor();
        int i = 0;
        while (i < this.tables.length) {
            m4.add(new LogQueueEntry(this.tables[i].seekLog(refName, updateIdx), i));
            ++i;
        }
        return m4;
    }

    int queueSize() {
        return Math.max(1, this.tables.length);
    }

    private class FilteringMergedRefCursor
    extends MergedRefCursor {
        final AnyObjectId filterId;
        Ref filteredRef;

        FilteringMergedRefCursor(AnyObjectId id) {
            this.filterId = id;
            this.filteredRef = null;
        }

        @Override
        public Ref getRef() {
            return this.filteredRef;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean next() throws IOException {
            boolean ok;
            while (ok = super.next()) {
                String name = super.getRef().getName();
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    RefCursor c = MergedReftable.this.seekRef(name);
                    try {
                        if (!c.next() || !this.filterId.equals(c.getRef().getObjectId())) continue;
                        this.filteredRef = c.getRef();
                        return true;
                    }
                    finally {
                        if (c == null) continue;
                        c.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            return false;
        }
    }

    private static class LogQueueEntry {
        final LogCursor lc;
        final int stackIdx;

        static int compare(LogQueueEntry a, LogQueueEntry b) {
            int cmp = a.name().compareTo(b.name());
            if (cmp == 0) {
                cmp = Long.signum(b.index() - a.index());
            }
            if (cmp == 0) {
                cmp = b.stackIdx - a.stackIdx;
            }
            return cmp;
        }

        LogQueueEntry(LogCursor lc, int stackIdx) {
            this.lc = lc;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.lc.getRefName();
        }

        long index() {
            return this.lc.getUpdateIndex();
        }
    }

    private class MergedLogCursor
    extends LogCursor {
        private final PriorityQueue<LogQueueEntry> queue;
        private String refName;
        private long updateIndex;
        private ReflogEntry entry;

        MergedLogCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), LogQueueEntry::compare);
        }

        void add(LogQueueEntry t2) throws IOException {
            if (t2.lc.next()) {
                this.queue.add(t2);
            } else {
                t2.lc.close();
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                LogQueueEntry t2;
                if ((t2 = this.queue.poll()) == null) {
                    return false;
                }
                this.refName = t2.lc.getRefName();
                this.updateIndex = t2.lc.getUpdateIndex();
                this.entry = t2.lc.getReflogEntry();
                include = MergedReftable.this.includeDeletes || this.entry != null;
                this.skipShadowed(this.refName, this.updateIndex);
                this.add(t2);
            } while (!include);
            return true;
        }

        private void skipShadowed(String name, long index) throws IOException {
            LogQueueEntry t2;
            while ((t2 = this.queue.peek()) != null && name.equals(t2.name()) && index == t2.index()) {
                this.add((LogQueueEntry)this.queue.remove());
            }
        }

        @Override
        public String getRefName() {
            return this.refName;
        }

        @Override
        public long getUpdateIndex() {
            return this.updateIndex;
        }

        @Override
        public ReflogEntry getReflogEntry() {
            return this.entry;
        }

        @Override
        public void close() {
            while (!this.queue.isEmpty()) {
                ((LogQueueEntry)this.queue.remove()).lc.close();
            }
        }
    }

    private class MergedRefCursor
    extends RefCursor {
        private final PriorityQueue<RefQueueEntry> queue;
        private RefQueueEntry head;
        private Ref ref;

        MergedRefCursor() {
            this.queue = new PriorityQueue(MergedReftable.this.queueSize(), RefQueueEntry::compare);
        }

        void add(RefQueueEntry t2) throws IOException {
            if (!t2.rc.next()) {
                t2.rc.close();
            } else if (this.head == null) {
                RefQueueEntry p = this.queue.peek();
                if (p == null || RefQueueEntry.compare(t2, p) < 0) {
                    this.head = t2;
                } else {
                    this.head = this.queue.poll();
                    this.queue.add(t2);
                }
            } else if (RefQueueEntry.compare(t2, this.head) > 0) {
                this.queue.add(t2);
            } else {
                this.queue.add(this.head);
                this.head = t2;
            }
        }

        @Override
        public boolean next() throws IOException {
            boolean include;
            do {
                RefQueueEntry t2;
                if ((t2 = this.poll()) == null) {
                    return false;
                }
                this.ref = t2.rc.getRef();
                include = MergedReftable.this.includeDeletes || !t2.rc.wasDeleted();
                this.add(t2);
                this.skipShadowedRefs(this.ref.getName());
            } while (!include);
            return true;
        }

        @Override
        public void seekPastPrefix(String prefixName) throws IOException {
            ArrayList<RefQueueEntry> entriesToAdd = new ArrayList<RefQueueEntry>();
            entriesToAdd.addAll(this.queue);
            if (this.head != null) {
                entriesToAdd.add(this.head);
            }
            this.head = null;
            this.queue.clear();
            for (RefQueueEntry entry : entriesToAdd) {
                entry.rc.seekPastPrefix(prefixName);
                this.add(entry);
            }
        }

        private RefQueueEntry poll() {
            RefQueueEntry e = this.head;
            if (e != null) {
                this.head = null;
                return e;
            }
            return this.queue.poll();
        }

        private void skipShadowedRefs(String name) throws IOException {
            while (true) {
                RefQueueEntry t2;
                RefQueueEntry refQueueEntry = t2 = this.head != null ? this.head : this.queue.peek();
                if (t2 == null || !name.equals(t2.name())) break;
                this.add(this.poll());
            }
        }

        @Override
        public Ref getRef() {
            return this.ref;
        }

        @Override
        public void close() {
            if (this.head != null) {
                this.head.rc.close();
                this.head = null;
            }
            while (!this.queue.isEmpty()) {
                ((RefQueueEntry)this.queue.remove()).rc.close();
            }
        }
    }

    private static class RefQueueEntry {
        final RefCursor rc;
        final int stackIdx;

        static int compare(RefQueueEntry a, RefQueueEntry b) {
            int cmp = a.name().compareTo(b.name());
            if (cmp == 0) {
                cmp = Long.signum(b.updateIndex() - a.updateIndex());
            }
            if (cmp == 0) {
                cmp = b.stackIdx - a.stackIdx;
            }
            return cmp;
        }

        RefQueueEntry(RefCursor rc, int stackIdx) {
            this.rc = rc;
            this.stackIdx = stackIdx;
        }

        String name() {
            return this.rc.getRef().getName();
        }

        long updateIndex() {
            return this.rc.getRef().getUpdateIndex();
        }
    }
}

