/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.DataInput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.DigestInputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.CorruptObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.PackMismatchException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackBitmapIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.SimpleDataInput;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.pack.PackExt;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.Hex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.IO;

final class PackReverseIndexV1
implements PackReverseIndex {
    static final int OID_VERSION_SHA1 = 1;
    static final int OID_VERSION_SHA256 = 2;
    private static final int SHA1_BYTES = 20;
    private final DigestInputStream inputStream;
    private final DataInput dataIn;
    private final PackBitmapIndex.SupplierWithIOException<PackIndex> packIndexSupplier;
    private int objectCount;
    private byte[] packChecksum;
    private int[] indexPositionsSortedByOffset;
    private PackIndex packIndex;

    PackReverseIndexV1(DigestInputStream inputStream, long objectCount, PackBitmapIndex.SupplierWithIOException<PackIndex> packIndexSupplier) throws IOException {
        try {
            this.objectCount = Math.toIntExact(objectCount);
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException(JGitText.get().hugeIndexesAreNotSupportedByJgitYet, e);
        }
        this.inputStream = inputStream;
        this.dataIn = new SimpleDataInput(inputStream);
        int oid_version = this.dataIn.readInt();
        switch (oid_version) {
            case 1: {
                break;
            }
            case 2: {
                throw new IOException(MessageFormat.format(JGitText.get().unsupportedObjectIdVersion, "SHA256"));
            }
            default: {
                throw new IOException(MessageFormat.format(JGitText.get().unsupportedObjectIdVersion, String.valueOf(oid_version)));
            }
        }
        this.indexPositionsSortedByOffset = new int[this.objectCount];
        this.packIndexSupplier = packIndexSupplier;
        this.parseBody();
        this.parseChecksums();
    }

    @Override
    public void verifyPackChecksum(String packFilePath) throws PackMismatchException {
        if (!Arrays.equals(this.packChecksum, this.getPackIndex().getChecksum())) {
            throw new PackMismatchException(MessageFormat.format(JGitText.get().packChecksumMismatch, packFilePath, PackExt.INDEX.getExtension(), Hex.toHexString(this.getPackIndex().getChecksum()), PackExt.REVERSE_INDEX.getExtension(), Hex.toHexString(this.packChecksum)));
        }
    }

    private void parseBody() throws IOException {
        int i = 0;
        while (i < this.objectCount) {
            this.indexPositionsSortedByOffset[i] = this.dataIn.readInt();
            ++i;
        }
    }

    private void parseChecksums() throws IOException {
        this.packChecksum = new byte[20];
        IO.readFully(this.inputStream, this.packChecksum);
        byte[] observedSelfChecksum = this.inputStream.getMessageDigest().digest();
        byte[] readSelfChecksum = new byte[20];
        IO.readFully(this.inputStream, readSelfChecksum);
        if (!Arrays.equals(readSelfChecksum, observedSelfChecksum)) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().corruptReverseIndexChecksumIncorrect, Hex.toHexString(readSelfChecksum), Hex.toHexString(observedSelfChecksum)));
        }
    }

    @Override
    public ObjectId findObject(long offset) {
        int reversePosition = this.findPosition(offset);
        if (reversePosition < 0) {
            return null;
        }
        int forwardPosition = this.findForwardPositionByReversePosition(reversePosition);
        return this.getPackIndex().getObjectId(forwardPosition);
    }

    @Override
    public long findNextOffset(long offset, long maxOffset) throws CorruptObjectException {
        int position = this.findPosition(offset);
        if (position < 0) {
            throw new CorruptObjectException(MessageFormat.format(JGitText.get().cantFindObjectInReversePackIndexForTheSpecifiedOffset, offset));
        }
        if (position + 1 == this.objectCount) {
            return maxOffset;
        }
        return this.findOffsetByReversePosition(position + 1);
    }

    @Override
    public int findPosition(long offset) {
        return this.binarySearchByOffset(offset);
    }

    @Override
    public ObjectId findObjectByPosition(int position) {
        return this.getPackIndex().getObjectId(this.findForwardPositionByReversePosition(position));
    }

    private long findOffsetByReversePosition(int position) {
        return this.getPackIndex().getOffset(this.findForwardPositionByReversePosition(position));
    }

    private int findForwardPositionByReversePosition(int reversePosition) {
        assert (reversePosition >= 0);
        assert (reversePosition < this.indexPositionsSortedByOffset.length);
        return this.indexPositionsSortedByOffset[reversePosition];
    }

    private int binarySearchByOffset(long wantedOffset) {
        int low = 0;
        int high = this.objectCount - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long offsetAtMid = this.findOffsetByReversePosition(mid);
            if (offsetAtMid == wantedOffset) {
                return mid;
            }
            if (offsetAtMid > wantedOffset) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return -1;
    }

    private PackIndex getPackIndex() {
        if (this.packIndex == null) {
            try {
                this.packIndex = this.packIndexSupplier.get();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return this.packIndex;
    }
}

