/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsBlockCacheTable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.dfs.DfsStreamKey;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.pack.PackExt;

class DfsBlockCacheStats
implements DfsBlockCacheTable.BlockCacheStats {
    private final String name;
    private final AtomicReference<AtomicLong[]> statHit;
    private final AtomicReference<AtomicLong[]> statMiss;
    private final AtomicReference<AtomicLong[]> statEvict;
    private final AtomicReference<AtomicLong[]> liveBytes;

    DfsBlockCacheStats() {
        this("");
    }

    DfsBlockCacheStats(String name) {
        this.name = name;
        this.statHit = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.statMiss = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.statEvict = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
        this.liveBytes = new AtomicReference<AtomicLong[]>(DfsBlockCacheStats.newCounters());
    }

    @Override
    public String getName() {
        return this.name;
    }

    void incrementHit(DfsStreamKey key) {
        DfsBlockCacheStats.getStat(this.statHit, key).incrementAndGet();
    }

    void incrementMiss(DfsStreamKey key) {
        DfsBlockCacheStats.getStat(this.statMiss, key).incrementAndGet();
    }

    void incrementEvict(DfsStreamKey key) {
        DfsBlockCacheStats.getStat(this.statEvict, key).incrementAndGet();
    }

    void addToLiveBytes(DfsStreamKey key, long size) {
        DfsBlockCacheStats.getStat(this.liveBytes, key).addAndGet(size);
    }

    @Override
    public long[] getCurrentSize() {
        return DfsBlockCacheStats.getStatVals(this.liveBytes);
    }

    @Override
    public long[] getHitCount() {
        return DfsBlockCacheStats.getStatVals(this.statHit);
    }

    @Override
    public long[] getMissCount() {
        return DfsBlockCacheStats.getStatVals(this.statMiss);
    }

    @Override
    public long[] getTotalRequestCount() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] cnt = new long[Math.max(hit.length, miss.length)];
        int i = 0;
        while (i < hit.length) {
            int n = i;
            cnt[n] = cnt[n] + hit[i].get();
            ++i;
        }
        i = 0;
        while (i < miss.length) {
            int n = i;
            cnt[n] = cnt[n] + miss[i].get();
            ++i;
        }
        return cnt;
    }

    @Override
    public long[] getHitRatio() {
        AtomicLong[] hit = this.statHit.get();
        AtomicLong[] miss = this.statMiss.get();
        long[] ratio = new long[Math.max(hit.length, miss.length)];
        int i = 0;
        while (i < ratio.length) {
            long missVal;
            long hitVal;
            long total;
            ratio[i] = i >= hit.length ? 0L : (i >= miss.length ? 100L : ((total = (hitVal = hit[i].get()) + (missVal = miss[i].get())) == 0L ? 0L : hitVal * 100L / total));
            ++i;
        }
        return ratio;
    }

    @Override
    public long[] getEvictions() {
        return DfsBlockCacheStats.getStatVals(this.statEvict);
    }

    private static AtomicLong[] newCounters() {
        AtomicLong[] ret = new AtomicLong[PackExt.values().length];
        int i = 0;
        while (i < ret.length) {
            ret[i] = new AtomicLong();
            ++i;
        }
        return ret;
    }

    private static long[] getStatVals(AtomicReference<AtomicLong[]> stat) {
        AtomicLong[] stats = stat.get();
        long[] cnt = new long[stats.length];
        int i = 0;
        while (i < stats.length) {
            cnt[i] = stats[i].get();
            ++i;
        }
        return cnt;
    }

    private static AtomicLong getStat(AtomicReference<AtomicLong[]> stats, DfsStreamKey key) {
        AtomicLong[] vals;
        AtomicLong[] expect;
        int pos = key.packExtPos;
        do {
            if (pos < (vals = stats.get()).length) {
                return vals[pos];
            }
            expect = vals;
            vals = new AtomicLong[Math.max(pos + 1, PackExt.values().length)];
            System.arraycopy(expect, 0, vals, 0, expect.length);
            int i = expect.length;
            while (i < vals.length) {
                vals[i] = new AtomicLong();
                ++i;
            }
        } while (!stats.compareAndSet(expect, vals));
        return vals[pos];
    }
}

