/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.InvalidTagNameException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.NoHeadException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.UnsupportedSigningFormatException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.GpgConfig;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectInserter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.PersonIdent;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.RefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Signer;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Signers;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.TagBuilder;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevObject;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.CredentialsProvider;

public class TagCommand
extends GitCommand<Ref> {
    private RevObject id;
    private String name;
    private String message;
    private PersonIdent tagger;
    private Boolean signed;
    private boolean forceUpdate;
    private Boolean annotated;
    private String signingKey;
    private GpgConfig gpgConfig;
    private Signer signer;
    private CredentialsProvider credentialsProvider = CredentialsProvider.getDefault();

    protected TagCommand(Repository repo) {
        super(repo);
    }

    /*
     * Loose catch block
     */
    @Override
    public Ref call() throws GitAPIException, ConcurrentRefUpdateException, InvalidTagNameException, NoHeadException {
        this.checkCallable();
        this.processOptions();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (RevWalk revWalk = new RevWalk(this.repo);){
                Ref ref;
                ObjectInserter inserter;
                Throwable throwable2;
                block26: {
                    if (this.id == null) {
                        ObjectId objectId = this.repo.resolve("HEAD^{commit}");
                        if (objectId == null) {
                            throw new NoHeadException(JGitText.get().tagOnRepoWithoutHEADCurrentlyNotSupported);
                        }
                        this.id = revWalk.parseCommit(objectId);
                    }
                    if (!this.isAnnotated()) {
                        return this.updateTagRef(this.id, revWalk, this.name, "SimpleTag[" + this.name + " : " + String.valueOf(this.id) + "]");
                    }
                    TagBuilder newTag = new TagBuilder();
                    newTag.setTag(this.name);
                    newTag.setMessage(this.message);
                    newTag.setTagger(this.tagger);
                    newTag.setObjectId(this.id);
                    if (this.signer != null) {
                        this.signer.signObject(this.repo, this.gpgConfig, newTag, this.tagger, this.signingKey, this.credentialsProvider);
                    }
                    throwable2 = null;
                    Object var6_10 = null;
                    inserter = this.repo.newObjectInserter();
                    ObjectId tagId = inserter.insert(newTag);
                    inserter.flush();
                    String tag = newTag.getTag();
                    ref = this.updateTagRef(tagId, revWalk, tag, newTag.toString());
                    if (inserter == null) break block26;
                    inserter.close();
                }
                return ref;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (inserter != null) {
                                inserter.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfTagCommand, e);
        }
    }

    private Ref updateTagRef(ObjectId tagId, RevWalk revWalk, String tagName, String newTagToString) throws IOException, ConcurrentRefUpdateException, RefAlreadyExistsException {
        String refName = "refs/tags/" + tagName;
        RefUpdate tagRef = this.repo.updateRef(refName);
        tagRef.setNewObjectId(tagId);
        tagRef.setForceUpdate(this.forceUpdate);
        tagRef.setRefLogMessage("tagged " + this.name, false);
        RefUpdate.Result updateResult = tagRef.update(revWalk);
        switch (updateResult) {
            case NEW: 
            case FORCED: {
                return this.repo.exactRef(refName);
            }
            case LOCK_FAILURE: {
                throw new ConcurrentRefUpdateException(JGitText.get().couldNotLockHEAD, tagRef.getRef(), updateResult);
            }
            case NO_CHANGE: {
                if (this.forceUpdate) {
                    return this.repo.exactRef(refName);
                }
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString), updateResult);
            }
            case REJECTED: {
                throw new RefAlreadyExistsException(MessageFormat.format(JGitText.get().tagAlreadyExists, newTagToString), updateResult);
            }
        }
        throw new JGitInternalException(MessageFormat.format(JGitText.get().updatingRefFailed, new Object[]{refName, newTagToString, updateResult}));
    }

    private void processOptions() throws InvalidTagNameException, UnsupportedSigningFormatException {
        if (this.name == null || !Repository.isValidRefName("refs/tags/" + this.name)) {
            throw new InvalidTagNameException(MessageFormat.format(JGitText.get().tagNameInvalid, this.name == null ? "<null>" : this.name));
        }
        if (!this.isAnnotated()) {
            if (this.message != null && !this.message.isEmpty() || this.tagger != null) {
                throw new JGitInternalException(JGitText.get().messageAndTaggerNotAllowedInUnannotatedTags);
            }
        } else {
            if (this.tagger == null) {
                this.tagger = new PersonIdent(this.repo);
            }
            if (!Boolean.FALSE.equals(this.signed) || this.signingKey != null) {
                boolean doSign;
                if (this.gpgConfig == null) {
                    this.gpgConfig = new GpgConfig(this.repo.getConfig());
                }
                boolean bl = doSign = this.isSigned() || this.gpgConfig.isSignAllTags();
                if (!Boolean.TRUE.equals(this.annotated) && !doSign) {
                    doSign = this.gpgConfig.isSignAnnotated();
                }
                if (doSign) {
                    if (this.signer == null) {
                        this.signer = Signers.get(this.gpgConfig.getKeyFormat());
                        if (this.signer == null) {
                            throw new UnsupportedSigningFormatException(MessageFormat.format(JGitText.get().signatureTypeUnknown, this.gpgConfig.getKeyFormat().toConfigValue()));
                        }
                    }
                    if (this.message != null && !this.message.isEmpty() && !this.message.endsWith("\n")) {
                        this.message = String.valueOf(this.message) + "\n";
                    }
                }
            }
        }
    }

    public TagCommand setName(String name) {
        this.checkCallable();
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public TagCommand setMessage(String message) {
        this.checkCallable();
        this.message = message;
        return this;
    }

    public boolean isSigned() {
        return Boolean.TRUE.equals(this.signed) || this.signingKey != null;
    }

    public TagCommand setSigned(boolean signed) {
        this.checkCallable();
        this.signed = signed;
        return this;
    }

    public TagCommand setSigner(Signer signer) {
        this.checkCallable();
        this.signer = signer;
        return this;
    }

    public TagCommand setGpgConfig(GpgConfig config) {
        this.checkCallable();
        this.gpgConfig = config;
        return this;
    }

    public TagCommand setTagger(PersonIdent tagger) {
        this.checkCallable();
        this.tagger = tagger;
        return this;
    }

    public PersonIdent getTagger() {
        return this.tagger;
    }

    public RevObject getObjectId() {
        return this.id;
    }

    public TagCommand setObjectId(RevObject id) {
        this.checkCallable();
        this.id = id;
        return this;
    }

    public boolean isForceUpdate() {
        return this.forceUpdate;
    }

    public TagCommand setForceUpdate(boolean forceUpdate) {
        this.checkCallable();
        this.forceUpdate = forceUpdate;
        return this;
    }

    public TagCommand setAnnotated(boolean annotated) {
        this.checkCallable();
        this.annotated = annotated;
        return this;
    }

    public boolean isAnnotated() {
        boolean setExplicitly;
        boolean bl = setExplicitly = Boolean.TRUE.equals(this.annotated) || this.isSigned();
        if (setExplicitly) {
            return true;
        }
        return this.annotated == null;
    }

    public TagCommand setSigningKey(String signingKey) {
        this.checkCallable();
        this.signingKey = signingKey;
        return this;
    }

    public String getSigningKey() {
        return this.signingKey;
    }

    public TagCommand setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.checkCallable();
        this.credentialsProvider = credentialsProvider;
        return this;
    }
}

