/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.CloneCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.FetchCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.Git;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.MergeCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.RebaseCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.TransportCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.CheckoutConflictException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.InvalidConfigurationException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.JGitInternalException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.NoHeadException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.NoMessageException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.RefNotFoundException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.dircache.DirCacheCheckout;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.ConfigInvalidException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.LockFile;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Constants;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.RefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.merge.MergeStrategy;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevCommit;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.submodule.SubmoduleWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.FileUtils;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;
    private boolean clonedRestored;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    private static boolean submoduleExists(File gitDir) {
        if (gitDir != null && gitDir.isDirectory()) {
            File[] files = gitDir.listFiles();
            return files != null && files.length != 0;
        }
        return false;
    }

    private static void restoreSubmodule(File gitDir, File workingTree) throws IOException {
        LockFile dotGitLock = new LockFile(new File(workingTree, ".git"));
        if (dotGitLock.lock()) {
            String content = "gitdir: " + SubmoduleUpdateCommand.getRelativePath(gitDir, workingTree);
            dotGitLock.write(Constants.encode(content));
            dotGitLock.commit();
        }
    }

    private static String getRelativePath(File gitDir, File workingTree) {
        File relPath;
        try {
            relPath = workingTree.toPath().relativize(gitDir.toPath()).toFile();
        }
        catch (IllegalArgumentException e) {
            relPath = gitDir;
        }
        return FileUtils.pathToString(relPath);
    }

    private String determineUpdateMode(String mode) {
        if (this.clonedRestored) {
            return "checkout";
        }
        return mode;
    }

    private Repository getOrCloneSubmodule(SubmoduleWalk generator, String url) throws IOException, GitAPIException {
        Repository repository = generator.getRepository();
        boolean restored = false;
        boolean cloned = false;
        if (repository == null) {
            File gitDir = new File(new File(this.repo.getCommonDirectory(), "modules"), generator.getPath());
            if (SubmoduleUpdateCommand.submoduleExists(gitDir)) {
                SubmoduleUpdateCommand.restoreSubmodule(gitDir, generator.getDirectory());
                restored = true;
                this.clonedRestored = true;
                repository = generator.getRepository();
            } else {
                if (this.callback != null) {
                    this.callback.cloningSubmodule(generator.getPath());
                }
                CloneCommand clone = Git.cloneRepository();
                this.configure(clone);
                clone.setURI(url);
                clone.setDirectory(generator.getDirectory());
                clone.setGitDir(gitDir);
                clone.setRelativePaths(true);
                if (this.monitor != null) {
                    clone.setProgressMonitor(this.monitor);
                }
                repository = clone.call().getRepository();
                cloned = true;
                this.clonedRestored = true;
            }
        }
        if ((this.fetch || restored) && !cloned) {
            if (this.fetchCallback != null) {
                this.fetchCallback.fetchingSubmodule(generator.getPath());
            }
            FetchCommand fetchCommand = Git.wrap(repository).fetch();
            if (this.monitor != null) {
                fetchCommand.setProgressMonitor(this.monitor);
            }
            this.configure(fetchCommand);
            fetchCommand.call();
        }
        return repository;
    }

    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try {
            Throwable throwable = null;
            Object var2_5 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
                if (!this.paths.isEmpty()) {
                    generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
                }
                ArrayList<String> updated = new ArrayList<String>();
                while (generator.next()) {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    this.clonedRestored = false;
                    Throwable throwable2 = null;
                    Object var7_12 = null;
                    try {
                        Repository submoduleRepo = this.getOrCloneSubmodule(generator, url);
                        try {
                            try (RevWalk walk = new RevWalk(submoduleRepo);){
                                RevCommit commit = walk.parseCommit(generator.getObjectId());
                                String update = this.determineUpdateMode(generator.getConfigUpdate());
                                if ("merge".equals(update)) {
                                    MergeCommand merge = new MergeCommand(submoduleRepo);
                                    merge.include(commit);
                                    merge.setProgressMonitor(this.monitor);
                                    merge.setStrategy(this.strategy);
                                    merge.call();
                                } else if ("rebase".equals(update)) {
                                    RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                                    rebase.setUpstream(commit);
                                    rebase.setProgressMonitor(this.monitor);
                                    rebase.setStrategy(this.strategy);
                                    rebase.call();
                                } else {
                                    DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                                    co.setFailOnConflict(true);
                                    co.setProgressMonitor(this.monitor);
                                    co.checkout();
                                    RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                                    refUpdate.setNewObjectId(commit);
                                    refUpdate.forceUpdate();
                                    if (this.callback != null) {
                                        this.callback.checkingOut(commit, generator.getPath());
                                    }
                                }
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (submoduleRepo != null) {
                                submoduleRepo.close();
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                        } else if (throwable2 != throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        throw throwable2;
                    }
                    updated.add(generator.getPath());
                }
                return updated;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

