/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.GitCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.GitAPIException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.InvalidRefNameException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.api.errors.RefNotFoundException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogEntry;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ReflogReader;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Repository;

public class ReflogCommand
extends GitCommand<Collection<ReflogEntry>> {
    private String ref = "HEAD";

    public ReflogCommand(Repository repo) {
        super(repo);
    }

    public ReflogCommand setRef(String ref) {
        this.checkCallable();
        this.ref = ref;
        return this;
    }

    @Override
    public Collection<ReflogEntry> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            ReflogReader reader = this.repo.getRefDatabase().getReflogReader(this.ref);
            if (reader == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.ref));
            }
            return reader.getReverseEntries();
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, this.ref), e);
        }
    }
}

