/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.net.minecraftforge.gitver.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

final class Lazy<T>
implements Supplier<T> {
    private Supplier<T> supplier;
    @Nullable
    private T value;

    static <T> Lazy<T> of(Supplier<T> supplier) {
        return new Lazy<T>(supplier);
    }

    private Lazy(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Override
    public T get() {
        return this.value != null ? this.value : (this.value = this.supplier.get());
    }

    void reset() {
        this.value = null;
    }

    void modify(Consumer<T> action) {
        Supplier<Object> supplier = this.value != null ? () -> this.value : this.supplier;
        this.supplier = () -> {
            Object value = supplier.get();
            action.accept(value);
            return value;
        };
        this.value = null;
    }
}

