/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.symmetric;

import java.util.Arrays;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.BitmapStorage32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.symmetric.EWAHPointer32;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.symmetric.UpdateableBitmapFunction32;

public final class ThresholdFuncBitmap32
extends UpdateableBitmapFunction32 {
    private final int min;
    private int[] buffers;
    private int bufferUsed;
    private final int[] bufcounters = new int[64];
    private static final int[] zeroes64 = new int[64];

    public ThresholdFuncBitmap32(int min2) {
        this.min = min2;
        this.buffers = new int[16];
        this.bufferUsed = 0;
    }

    @Override
    public void dispatch(BitmapStorage32 out, int runBegin, int runend) {
        int runLength = runend - runBegin;
        if (this.hammingWeight >= this.min) {
            out.addStreamOfEmptyWords(true, runLength);
        } else if (this.litWeight + this.hammingWeight < this.min) {
            out.addStreamOfEmptyWords(false, runLength);
        } else {
            int deficit = this.min - this.hammingWeight;
            if (deficit == 1) {
                this.orLiterals(out, runBegin, runLength);
                return;
            }
            this.bufferUsed = this.getNumberOfLiterals();
            if (this.bufferUsed == deficit) {
                this.andLiterals(out, runBegin, runLength);
            } else {
                this.generalLiterals(deficit, out, runBegin, runLength);
            }
        }
    }

    private int threshold2buf(int t2, int[] buf, int bufUsed) {
        int result = 0;
        int[] counters = this.bufcounters;
        System.arraycopy(zeroes64, 0, counters, 0, 64);
        for (int k = 0; k < bufUsed; ++k) {
            int t22;
            for (int bitset = buf[k]; bitset != 0; bitset ^= t22) {
                t22 = bitset & -bitset;
                int n = Integer.bitCount(t22 - 1);
                counters[n] = counters[n] + 1;
            }
        }
        for (int pos = 0; pos < 64; ++pos) {
            if (counters[pos] < t2) continue;
            result = (int)((long)result | 1L << pos);
        }
        return result;
    }

    private static int threshold3(int t2, int[] buffers, int bufUsed) {
        if (buffers.length == 0) {
            return 0;
        }
        int[] v = new int[t2];
        v[0] = buffers[0];
        for (int k = 1; k < bufUsed; ++k) {
            int m4;
            int c = buffers[k];
            for (int j = m4 = Math.min(t2 - 1, k); j >= 1; --j) {
                int n = j;
                v[n] = v[n] | c & v[j - 1];
            }
            v[0] = v[0] | c;
        }
        return v[t2 - 1];
    }

    private int threshold4(int t2, int[] buf, int bufUsed) {
        if (t2 >= 128) {
            return this.threshold2buf(t2, buf, bufUsed);
        }
        int b = 0;
        for (int k = 0; k < bufUsed; ++k) {
            b += Integer.bitCount(buf[k]);
        }
        if (2 * b >= bufUsed * t2) {
            return ThresholdFuncBitmap32.threshold3(t2, buf, bufUsed);
        }
        return this.threshold2buf(t2, buf, bufUsed);
    }

    private void orLiterals(BitmapStorage32 out, int runBegin, int runLength) {
        for (int i = 0; i < runLength; ++i) {
            int w = 0;
            for (EWAHPointer32 r : this.getLiterals()) {
                w |= r.iterator.getLiteralWordAt(i + runBegin - r.beginOfRun());
            }
            out.addWord(w);
        }
    }

    private void andLiterals(BitmapStorage32 out, int runBegin, int runLength) {
        for (int i = 0; i < runLength; ++i) {
            int w = -1;
            for (EWAHPointer32 r : this.getLiterals()) {
                w &= r.iterator.getLiteralWordAt(i + runBegin - r.beginOfRun());
            }
            out.addWord(w);
        }
    }

    private void generalLiterals(int deficit, BitmapStorage32 out, int runBegin, int runLength) {
        if (this.bufferUsed > this.buffers.length) {
            this.buffers = Arrays.copyOf(this.buffers, 2 * this.bufferUsed);
        }
        for (int i = 0; i < runLength; ++i) {
            int p = 0;
            for (EWAHPointer32 r : this.getLiterals()) {
                this.buffers[p++] = r.iterator.getLiteralWordAt(i + runBegin - r.beginOfRun());
            }
            out.addWord(this.threshold4(deficit, this.buffers, this.bufferUsed));
        }
    }
}

