/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32;

import java.nio.IntBuffer;
import net.minecraftforge.gradleutils.shadow.com.googlecode.javaewah32.Buffer32;

final class IntBufferWrapper
implements Buffer32,
Cloneable {
    private int actualSizeInWords = 1;
    private IntBuffer buffer;

    public IntBufferWrapper(IntBuffer buffer) {
        this.buffer = buffer;
    }

    public IntBufferWrapper(IntBuffer slice, int sizeInWords) {
        this.buffer = slice;
        this.actualSizeInWords = sizeInWords;
    }

    @Override
    public int sizeInWords() {
        return this.actualSizeInWords;
    }

    @Override
    public void ensureCapacity(int capacity) {
        if (capacity > this.buffer.capacity()) {
            throw new RuntimeException("Cannot increase buffer capacity. Current capacity: " + this.buffer.capacity() + ". New capacity: " + capacity);
        }
    }

    @Override
    public int getWord(int position) {
        return this.buffer.get(position);
    }

    @Override
    public int getLastWord() {
        return this.getWord(this.actualSizeInWords - 1);
    }

    @Override
    public void clear() {
        this.actualSizeInWords = 1;
        this.setWord(0, 0);
    }

    @Override
    public void trim() {
    }

    @Override
    public void setWord(int position, int word) {
        this.buffer.put(position, word);
    }

    @Override
    public void setLastWord(int word) {
        this.setWord(this.actualSizeInWords - 1, word);
    }

    @Override
    public void push_back(int word) {
        this.setWord(this.actualSizeInWords++, word);
    }

    @Override
    public void push_back(Buffer32 buffer, int start, int number) {
        for (int i = 0; i < number; ++i) {
            this.push_back(buffer.getWord(start + i));
        }
    }

    @Override
    public void negative_push_back(Buffer32 buffer, int start, int number) {
        for (int i = 0; i < number; ++i) {
            this.push_back(~buffer.getWord(start + i));
        }
    }

    @Override
    public void removeLastWord() {
        this.setWord(--this.actualSizeInWords, 0);
    }

    @Override
    public void negateWord(int position) {
        this.setWord(position, ~this.getWord(position));
    }

    @Override
    public void andWord(int position, int mask) {
        this.setWord(position, this.getWord(position) & mask);
    }

    @Override
    public void orWord(int position, int mask) {
        this.setWord(position, this.getWord(position) | mask);
    }

    @Override
    public void andLastWord(int mask) {
        this.andWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void orLastWord(int mask) {
        this.orWord(this.actualSizeInWords - 1, mask);
    }

    @Override
    public void expand(int position, int length) {
        for (int i = this.actualSizeInWords - position - 1; i >= 0; --i) {
            this.setWord(position + length + i, this.getWord(position + i));
        }
        this.actualSizeInWords += length;
    }

    @Override
    public void collapse(int position, int length) {
        int i;
        for (i = 0; i < this.actualSizeInWords - position - length; ++i) {
            this.setWord(position + i, this.getWord(position + length + i));
        }
        for (i = 0; i < length; ++i) {
            this.removeLastWord();
        }
    }

    @Override
    public IntBufferWrapper clone() throws CloneNotSupportedException {
        return new IntBufferWrapper(this.buffer, this.actualSizeInWords);
    }

    @Override
    public void swap(Buffer32 other) {
        if (other instanceof IntBufferWrapper) {
            IntBufferWrapper o = (IntBufferWrapper)other;
            IntBuffer tmp = this.buffer;
            int tmp2 = this.actualSizeInWords;
            this.actualSizeInWords = o.actualSizeInWords;
            this.buffer = o.buffer;
            o.actualSizeInWords = tmp2;
            o.buffer = tmp;
        } else {
            other.swap(this);
        }
    }
}

