/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.tomlj;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.EnumSet;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.tomlj.JsonOptions;
import net.minecraftforge.gradleutils.shadow.org.tomlj.JsonSerializer;
import net.minecraftforge.gradleutils.shadow.org.tomlj.TomlInvalidTypeException;
import net.minecraftforge.gradleutils.shadow.org.tomlj.TomlPosition;
import net.minecraftforge.gradleutils.shadow.org.tomlj.TomlSerializer;
import net.minecraftforge.gradleutils.shadow.org.tomlj.TomlTable;
import net.minecraftforge.gradleutils.shadow.org.tomlj.TomlType;

public interface TomlArray {
    public int size();

    public boolean isEmpty();

    public boolean containsStrings();

    public boolean containsLongs();

    public boolean containsDoubles();

    public boolean containsBooleans();

    public boolean containsOffsetDateTimes();

    public boolean containsLocalDateTimes();

    public boolean containsLocalDates();

    public boolean containsLocalTimes();

    public boolean containsArrays();

    public boolean containsTables();

    public Object get(int var1);

    public TomlPosition inputPositionOf(int var1);

    default public String getString(int index) {
        Object value = this.get(index);
        if (!(value instanceof String)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (String)value;
    }

    default public long getLong(int index) {
        Object value = this.get(index);
        if (!(value instanceof Long)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (Long)value;
    }

    default public double getDouble(int index) {
        Object value = this.get(index);
        if (!(value instanceof Double)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (Double)value;
    }

    default public boolean getBoolean(int index) {
        Object value = this.get(index);
        if (!(value instanceof Boolean)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (Boolean)value;
    }

    default public OffsetDateTime getOffsetDateTime(int index) {
        Object value = this.get(index);
        if (!(value instanceof OffsetDateTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (OffsetDateTime)value;
    }

    default public LocalDateTime getLocalDateTime(int index) {
        Object value = this.get(index);
        if (!(value instanceof LocalDateTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (LocalDateTime)value;
    }

    default public LocalDate getLocalDate(int index) {
        Object value = this.get(index);
        if (!(value instanceof LocalDate)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (LocalDate)value;
    }

    default public LocalTime getLocalTime(int index) {
        Object value = this.get(index);
        if (!(value instanceof LocalTime)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (LocalTime)value;
    }

    default public TomlArray getArray(int index) {
        Object value = this.get(index);
        if (!(value instanceof TomlArray)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (TomlArray)value;
    }

    default public TomlTable getTable(int index) {
        Object value = this.get(index);
        if (!(value instanceof TomlTable)) {
            throw new TomlInvalidTypeException("key at index " + index + " is a " + TomlType.typeNameFor(value));
        }
        return (TomlTable)value;
    }

    public List<Object> toList();

    default public String toJson(JsonOptions ... options) {
        return this.toJson(JsonOptions.setFrom(options));
    }

    default public String toJson(EnumSet<JsonOptions> options) {
        StringBuilder builder = new StringBuilder();
        try {
            this.toJson((Appendable)builder, options);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toJson(Appendable appendable, JsonOptions ... options) throws IOException {
        this.toJson(appendable, JsonOptions.setFrom(options));
    }

    default public void toJson(Appendable appendable, EnumSet<JsonOptions> options) throws IOException {
        JsonSerializer.toJson(this, appendable, options);
    }

    default public String toToml() {
        StringBuilder builder = new StringBuilder();
        try {
            this.toToml(builder);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return builder.toString();
    }

    default public void toToml(Appendable appendable) throws IOException {
        TomlSerializer.toToml(this, appendable);
    }
}

