/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Collection;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.TreeWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.treewalk.filter.TreeFilter;

public abstract class AndTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL) {
            return b;
        }
        if (b == ALL) {
            return a;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list) {
        if (list.length == 2) {
            return AndTreeFilter.create(list[0], list[1]);
        }
        if (list.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.length];
        System.arraycopy(list, 0, subfilters, 0, list.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list) {
        if (list.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list.size()];
        list.toArray(subfilters);
        if (subfilters.length == 2) {
            return AndTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends AndTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int ra = this.a.matchFilter(walker);
            if (ra == 1) {
                return 1;
            }
            int rb = this.b.matchFilter(walker);
            if (rb == 1) {
                return 1;
            }
            if (ra == -1 || rb == -1) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        @Override
        public String toString() {
            return "(" + this.a.toString() + " AND " + this.b.toString() + ")";
        }
    }

    private static class List
    extends AndTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list) {
            this.subfilters = list;
        }

        @Override
        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.matchFilter(walker) <= 0;
        }

        @Override
        public int matchFilter(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            int m4 = 0;
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                int r = f.matchFilter(walker);
                if (r == 1) {
                    return 1;
                }
                if (r == -1) {
                    m4 = -1;
                }
                ++n2;
            }
            return m4;
        }

        @Override
        public boolean shouldBeRecursive() {
            TreeFilter[] treeFilterArray = this.subfilters;
            int n = this.subfilters.length;
            int n2 = 0;
            while (n2 < n) {
                TreeFilter f = treeFilterArray[n2];
                if (f.shouldBeRecursive()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        @Override
        public TreeFilter clone() {
            TreeFilter[] s2 = new TreeFilter[this.subfilters.length];
            int i = 0;
            while (i < s2.length) {
                s2[i] = this.subfilters[i].clone();
                ++i;
            }
            return new List(s2);
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            int i = 0;
            while (i < this.subfilters.length) {
                if (i > 0) {
                    r.append(" AND ");
                }
                r.append(this.subfilters[i].toString());
                ++i;
            }
            r.append(")");
            return r.toString();
        }
    }
}

