/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public abstract class BlockSource
implements AutoCloseable {
    public static BlockSource from(final byte[] content) {
        return new BlockSource(){

            @Override
            public ByteBuffer read(long pos, int cnt) {
                ByteBuffer buf = ByteBuffer.allocate(cnt);
                if (pos < (long)content.length) {
                    int p = (int)pos;
                    int n = Math.min(cnt, content.length - p);
                    buf.put(content, p, n);
                }
                return buf;
            }

            @Override
            public long size() {
                return content.length;
            }

            @Override
            public void close() {
            }
        };
    }

    public static BlockSource from(FileInputStream in) {
        return BlockSource.from(in.getChannel());
    }

    public static BlockSource from(final FileChannel ch) {
        return new BlockSource(){

            @Override
            public ByteBuffer read(long pos, int blockSize) throws IOException {
                int n;
                ByteBuffer b = ByteBuffer.allocate(blockSize);
                ch.position(pos);
                while ((n = ch.read(b)) > 0 && b.position() < blockSize) {
                }
                return b;
            }

            @Override
            public long size() throws IOException {
                return ch.size();
            }

            @Override
            public void close() {
                try {
                    ch.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
    }

    public abstract ByteBuffer read(long var1, int var3) throws IOException;

    public abstract long size() throws IOException;

    public void adviseSequentialRead(long startPos, long endPos) {
    }

    @Override
    public abstract void close();
}

