/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.StandardCopyOption;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectory;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectoryUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.RefRename;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.RefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RefDirectoryRename
extends RefRename {
    private static final Logger LOG = LoggerFactory.getLogger(RefDirectoryRename.class);
    private final RefDirectory refdb;
    private ObjectId objId;
    private RefDirectoryUpdate tmp;

    RefDirectoryRename(RefDirectoryUpdate src, RefDirectoryUpdate dst) {
        super(src, dst);
        this.refdb = src.getRefDatabase();
    }

    protected RefDirectory getRefDirectory() {
        return this.refdb;
    }

    /*
     * Exception decompiling
     */
    @Override
    protected RefUpdate.Result doRename() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 27[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean renameLog(RefUpdate src, RefUpdate dst) {
        File srcLog = this.refdb.logFor(src.getName());
        File dstLog = this.refdb.logFor(dst.getName());
        if (!srcLog.exists()) {
            return true;
        }
        if (!RefDirectoryRename.rename(srcLog, dstLog)) {
            return false;
        }
        try {
            int levels = RefDirectory.levelsIn(src.getName()) - 2;
            RefDirectory.delete(srcLog, levels);
            return true;
        }
        catch (IOException e) {
            RefDirectoryRename.rename(dstLog, srcLog);
            return false;
        }
    }

    private static boolean rename(File src, File dst) {
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (AtomicMoveNotSupportedException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            // empty catch block
        }
        File dir = dst.getParentFile();
        if (!(!dir.exists() && dir.mkdirs() || dir.isDirectory())) {
            return false;
        }
        try {
            FileUtils.rename(src, dst, StandardCopyOption.ATOMIC_MOVE);
            return true;
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean linkHEAD(RefUpdate target) {
        try {
            RefDirectoryUpdate u = this.refdb.newUpdate("HEAD", false);
            u.disableRefLog();
            switch (u.link(target.getName())) {
                case NO_CHANGE: 
                case NEW: 
                case FORCED: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

