/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.annotations.Nullable;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.LockFailedException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.errors.MissingObjectException;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.LockFile;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.RefDirectory;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.ReflogWriter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.BatchRefUpdate;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectId;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ObjectIdRef;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.PersonIdent;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.ProgressMonitor;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.lib.Ref;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevObject;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevTag;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.revwalk.RevWalk;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.ReceiveCommand;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.RefList;

class PackedBatchRefUpdate
extends BatchRefUpdate {
    private RefDirectory refdb;
    private boolean shouldLockLooseRefs;

    PackedBatchRefUpdate(RefDirectory refdb) {
        this(refdb, true);
    }

    PackedBatchRefUpdate(RefDirectory refdb, boolean shouldLockLooseRefs) {
        super(refdb);
        this.refdb = refdb;
        this.shouldLockLooseRefs = shouldLockLooseRefs;
    }

    @Override
    public void execute(RevWalk walk, ProgressMonitor monitor, List<String> options) throws IOException {
        if (!this.isAtomic()) {
            super.execute(walk, monitor, options);
            return;
        }
        List<ReceiveCommand> pending = ReceiveCommand.filter(this.getCommands(), ReceiveCommand.Result.NOT_ATTEMPTED);
        if (pending.isEmpty()) {
            return;
        }
        if (pending.size() == 1) {
            super.execute(walk, monitor, options);
            return;
        }
        if (PackedBatchRefUpdate.containsSymrefs(pending)) {
            PackedBatchRefUpdate.reject(pending.get(0), ReceiveCommand.Result.REJECTED_OTHER_REASON, JGitText.get().atomicSymRefNotSupported, pending);
            return;
        }
        if (!this.blockUntilTimestamps(MAX_WAIT)) {
            return;
        }
        if (options != null) {
            this.setPushOptions(options);
        }
        if (!this.checkConflictingNames(pending)) {
            return;
        }
        if (!this.checkObjectExistence(walk, pending)) {
            return;
        }
        if (!this.checkNonFastForwards(walk, pending)) {
            return;
        }
        try {
            this.refdb.pack(pending.stream().map(ReceiveCommand::getRefName).collect(Collectors.toList()));
        }
        catch (LockFailedException e) {
            PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
            return;
        }
        Map<String, LockFile> locks = null;
        LockFile packedRefsLock = null;
        this.refdb.inProcessPackedRefsLock.lock();
        try {
            if (!this.refdb.isInClone() && this.shouldLockLooseRefs) {
                locks = this.lockLooseRefs(pending);
                if (locks == null) {
                    return;
                }
                this.refdb.pack(locks);
            }
            packedRefsLock = this.refdb.lockPackedRefsOrThrow();
            RefDirectory.PackedRefList oldPackedList = this.refdb.refreshPackedRefs();
            RefList<Ref> newRefs = PackedBatchRefUpdate.applyUpdates(walk, oldPackedList, pending);
            if (newRefs == null) {
                return;
            }
            try {
                this.refdb.commitPackedRefs(packedRefsLock, newRefs, oldPackedList, true);
            }
            catch (LockFailedException e) {
                PackedBatchRefUpdate.lockFailure(pending.get(0), pending);
                return;
            }
        }
        finally {
            try {
                PackedBatchRefUpdate.unlockAll(locks);
                if (packedRefsLock != null) {
                    packedRefsLock.unlock();
                }
            }
            finally {
                this.refdb.inProcessPackedRefsLock.unlock();
            }
        }
        this.refdb.fireRefsChanged();
        pending.forEach(c -> c.setResult(ReceiveCommand.Result.OK));
        this.writeReflog(pending);
    }

    private static boolean containsSymrefs(List<ReceiveCommand> commands) {
        for (ReceiveCommand cmd : commands) {
            if (cmd.getOldSymref() == null && cmd.getNewSymref() == null) continue;
            return true;
        }
        return false;
    }

    private boolean checkConflictingNames(List<ReceiveCommand> commands) throws IOException {
        HashSet<String> takenNames = new HashSet<String>();
        HashSet<String> takenPrefixes = new HashSet<String>();
        HashSet<String> deletes = new HashSet<String>();
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE) {
                takenNames.add(cmd.getRefName());
                PackedBatchRefUpdate.addPrefixesTo(cmd.getRefName(), takenPrefixes);
                continue;
            }
            deletes.add(cmd.getRefName());
        }
        Set<String> initialRefs = this.refdb.getRefs("").keySet();
        for (String name : initialRefs) {
            if (deletes.contains(name)) continue;
            takenNames.add(name);
            PackedBatchRefUpdate.addPrefixesTo(name, takenPrefixes);
        }
        for (ReceiveCommand cmd : commands) {
            if (cmd.getType() != ReceiveCommand.Type.DELETE && takenPrefixes.contains(cmd.getRefName())) {
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
            for (String prefix : PackedBatchRefUpdate.getPrefixes(cmd.getRefName())) {
                if (!takenNames.contains(prefix)) continue;
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkObjectExistence(RevWalk walk, List<ReceiveCommand> commands) throws IOException {
        for (ReceiveCommand cmd : commands) {
            try {
                if (cmd.getNewId().equals(ObjectId.zeroId())) continue;
                walk.parseAny(cmd.getNewId());
            }
            catch (MissingObjectException e) {
                PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_MISSING_OBJECT, commands);
                return false;
            }
        }
        return true;
    }

    private boolean checkNonFastForwards(RevWalk walk, List<ReceiveCommand> commands) throws IOException {
        if (this.isAllowNonFastForwards()) {
            return true;
        }
        for (ReceiveCommand cmd : commands) {
            cmd.updateType(walk);
            if (cmd.getType() != ReceiveCommand.Type.UPDATE_NONFASTFORWARD) continue;
            PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.REJECTED_NONFASTFORWARD, commands);
            return false;
        }
        return true;
    }

    @Nullable
    private Map<String, LockFile> lockLooseRefs(List<ReceiveCommand> commands) throws IOException {
        ReceiveCommand failed = null;
        HashMap<String, LockFile> locks = new HashMap<String, LockFile>();
        try {
            block4: for (int ms : this.refdb.getRetrySleepMs()) {
                failed = null;
                PackedBatchRefUpdate.unlockAll(locks);
                locks.clear();
                RefDirectory.sleep(ms);
                for (ReceiveCommand c : commands) {
                    LockFile lock;
                    String name = c.getRefName();
                    if (locks.put(name, lock = new LockFile(this.refdb.fileFor(name))) != null) {
                        throw new IOException(MessageFormat.format(JGitText.get().duplicateRef, name));
                    }
                    if (lock.lock()) continue;
                    failed = c;
                    continue block4;
                }
                HashMap<String, LockFile> result = locks;
                locks = null;
                HashMap<String, LockFile> hashMap = result;
                return hashMap;
            }
        }
        finally {
            PackedBatchRefUpdate.unlockAll(locks);
        }
        PackedBatchRefUpdate.lockFailure(failed != null ? failed : commands.get(0), commands);
        return null;
    }

    private static RefList<Ref> applyUpdates(RevWalk walk, RefList<Ref> refs, List<ReceiveCommand> commands) throws IOException {
        Collections.sort(commands, Comparator.comparing(ReceiveCommand::getRefName));
        int delta = 0;
        for (ReceiveCommand c : commands) {
            switch (c.getType()) {
                case DELETE: {
                    --delta;
                    break;
                }
                case CREATE: {
                    ++delta;
                }
            }
        }
        RefList.Builder<Ref> b = new RefList.Builder<Ref>(refs.size() + delta);
        int refIdx = 0;
        int cmdIdx = 0;
        while (refIdx < refs.size() || cmdIdx < commands.size()) {
            Ref ref = refIdx < refs.size() ? refs.get(refIdx) : null;
            ReceiveCommand cmd = cmdIdx < commands.size() ? commands.get(cmdIdx) : null;
            int cmp = 0;
            if (ref != null && cmd != null) {
                cmp = ref.getName().compareTo(cmd.getRefName());
            } else if (ref == null) {
                cmp = 1;
            } else if (cmd == null) {
                cmp = -1;
            }
            if (cmp < 0) {
                b.add(ref);
                ++refIdx;
                continue;
            }
            if (cmp > 0) {
                assert (cmd != null);
                if (cmd.getType() != ReceiveCommand.Type.CREATE) {
                    PackedBatchRefUpdate.lockFailure(cmd, commands);
                    return null;
                }
                b.add(PackedBatchRefUpdate.peeledRef(walk, cmd));
                ++cmdIdx;
                continue;
            }
            assert (cmd != null);
            assert (ref != null);
            if (!cmd.getOldId().equals(ref.getObjectId())) {
                PackedBatchRefUpdate.lockFailure(cmd, commands);
                return null;
            }
            if (cmd.getType() != ReceiveCommand.Type.DELETE) {
                b.add(PackedBatchRefUpdate.peeledRef(walk, cmd));
            }
            ++cmdIdx;
            ++refIdx;
        }
        return b.toRefList();
    }

    private void writeReflog(List<ReceiveCommand> commands) {
        PersonIdent ident = this.getRefLogIdent();
        if (ident == null) {
            ident = new PersonIdent(this.refdb.getRepository());
        }
        for (ReceiveCommand cmd : commands) {
            String strResult;
            if (cmd.getResult() != ReceiveCommand.Result.OK) continue;
            String name = cmd.getRefName();
            if (cmd.getType() == ReceiveCommand.Type.DELETE) {
                try {
                    RefDirectory.delete(this.refdb.logFor(name), RefDirectory.levelsIn(name));
                }
                catch (IOException iOException) {}
                continue;
            }
            if (this.isRefLogDisabled(cmd)) continue;
            String msg = this.getRefLogMessage(cmd);
            if (this.isRefLogIncludingResult(cmd) && (strResult = this.toResultString(cmd)) != null) {
                msg = msg.isEmpty() ? strResult : msg + ": " + strResult;
            }
            try {
                new ReflogWriter(this.refdb, this.isForceRefLog(cmd)).log(name, cmd.getOldId(), cmd.getNewId(), ident, msg);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String toResultString(ReceiveCommand cmd) {
        switch (cmd.getType()) {
            case CREATE: {
                return "created";
            }
            case UPDATE: {
                return this.isAllowNonFastForwards() ? "forced-update" : "fast-forward";
            }
            case UPDATE_NONFASTFORWARD: {
                return "forced-update";
            }
        }
        return null;
    }

    private static Ref peeledRef(RevWalk walk, ReceiveCommand cmd) throws IOException {
        ObjectId newId = cmd.getNewId().copy();
        RevObject obj = walk.parseAny(newId);
        if (obj instanceof RevTag) {
            return new ObjectIdRef.PeeledTag(Ref.Storage.PACKED, cmd.getRefName(), newId, walk.peel(obj).copy());
        }
        return new ObjectIdRef.PeeledNonTag(Ref.Storage.PACKED, cmd.getRefName(), newId);
    }

    private static void unlockAll(@Nullable Map<?, LockFile> locks) {
        if (locks != null) {
            locks.values().forEach(LockFile::unlock);
        }
    }

    private static void lockFailure(ReceiveCommand cmd, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, ReceiveCommand.Result.LOCK_FAILURE, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, List<ReceiveCommand> commands) {
        PackedBatchRefUpdate.reject(cmd, result, null, commands);
    }

    private static void reject(ReceiveCommand cmd, ReceiveCommand.Result result, String why, List<ReceiveCommand> commands) {
        cmd.setResult(result, why);
        for (ReceiveCommand c2 : commands) {
            if (c2.getResult() != ReceiveCommand.Result.OK) continue;
            c2.setResult(ReceiveCommand.Result.NOT_ATTEMPTED);
        }
        ReceiveCommand.abort(commands);
    }
}

