/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackReverseIndexWriter;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.transport.PackedObjectInfo;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.util.IntList;

final class PackReverseIndexWriterV1
extends PackReverseIndexWriter {
    private static final int DEFAULT_OID_VERSION = 1;

    PackReverseIndexWriterV1(OutputStream dst) {
        super(dst);
    }

    @Override
    protected void writeHeader() throws IOException {
        this.out.write(PackReverseIndex.MAGIC);
        this.dataOutput.writeInt(1);
        this.dataOutput.writeInt(1);
    }

    @Override
    protected void writeBody(List<? extends PackedObjectInfo> objectsByIndexPos) throws IOException {
        IntList positionsByOffset = IntList.filledWithRange(0, objectsByIndexPos.size());
        positionsByOffset.sort(new IndexPositionsByOffsetComparator(objectsByIndexPos));
        int i = 0;
        while (i < positionsByOffset.size()) {
            int indexPosition = positionsByOffset.get(i);
            this.dataOutput.writeInt(indexPosition);
            ++i;
        }
    }

    private static class IndexPositionsByOffsetComparator
    implements IntList.IntComparator {
        private List<? extends PackedObjectInfo> objectsByIndexPos;

        private IndexPositionsByOffsetComparator(List<? extends PackedObjectInfo> objectsByIndexPos) {
            this.objectsByIndexPos = objectsByIndexPos;
        }

        @Override
        public int compare(int firstIndexPosition, int secondIndexPosition) {
            return Long.compare(this.getOffset(firstIndexPosition), this.getOffset(secondIndexPosition));
        }

        private long getOffset(int indexPosition) {
            return this.objectsByIndexPos.get(indexPosition).getOffset();
        }
    }
}

