/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.JGitText;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackObjectSizeIndex;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackObjectSizeIndexV1;
import net.minecraftforge.gradleutils.shadow.org.eclipse.jgit.internal.storage.file.PackObjectSizeIndexWriter;

public class PackObjectSizeIndexLoader {
    public static PackObjectSizeIndex load(InputStream in) throws IOException {
        byte[] header = in.readNBytes(4);
        if (!Arrays.equals(header, PackObjectSizeIndexWriter.HEADER)) {
            throw new IOException(MessageFormat.format(JGitText.get().unreadableObjectSizeIndex, header.length, Arrays.toString(header)));
        }
        byte version = in.readNBytes(1)[0];
        if (version != 1) {
            throw new IOException(MessageFormat.format(JGitText.get().unsupportedObjectSizeIndexVersion, version));
        }
        return PackObjectSizeIndexV1.parse(in);
    }
}

